package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTransitGatewayVpcAttachmentsResponse(
    transitGatewayVpcAttachments: Option[
      Iterable[zio.aws.ec2.model.TransitGatewayVpcAttachment]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse = {
    import DescribeTransitGatewayVpcAttachmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse
      .builder()
      .optionallyWith(
        transitGatewayVpcAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.transitGatewayVpcAttachments)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse
      .wrap(buildAwsValue())
}
object DescribeTransitGatewayVpcAttachmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse =
      zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse(
        transitGatewayVpcAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def transitGatewayVpcAttachments
        : Option[List[zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly]]
    def nextToken: Option[String]
    def getTransitGatewayVpcAttachments: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "transitGatewayVpcAttachments",
      transitGatewayVpcAttachments
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse
  ) extends zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse.ReadOnly {
    override val transitGatewayVpcAttachments
        : Option[List[zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly]] =
      scala
        .Option(impl.transitGatewayVpcAttachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TransitGatewayVpcAttachment.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse
  ): zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse.ReadOnly =
    new Wrapper(impl)
}
