package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, DateTime}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeSpotPriceHistoryRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    availabilityZone: Option[String] = None,
    endTime: Option[DateTime] = None,
    instanceTypes: Option[Iterable[zio.aws.ec2.model.InstanceType]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None,
    productDescriptions: Option[Iterable[String]] = None,
    startTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest = {
    import DescribeSpotPriceHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.instanceTypesWithStrings)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        productDescriptions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.productDescriptions)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeSpotPriceHistoryRequest.ReadOnly =
    zio.aws.ec2.model.DescribeSpotPriceHistoryRequest.wrap(buildAwsValue())
}
object DescribeSpotPriceHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeSpotPriceHistoryRequest =
      zio.aws.ec2.model.DescribeSpotPriceHistoryRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        endTime.map(value => value),
        instanceTypes.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        productDescriptions.map(value => value),
        startTime.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def availabilityZone: Option[String]
    def endTime: Option[DateTime]
    def instanceTypes: Option[List[zio.aws.ec2.model.InstanceType]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def productDescriptions: Option[List[String]]
    def startTime: Option[DateTime]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getInstanceTypes
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.InstanceType]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProductDescriptions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("productDescriptions", productDescriptions)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest
  ) extends zio.aws.ec2.model.DescribeSpotPriceHistoryRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val endTime: Option[DateTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val instanceTypes: Option[List[zio.aws.ec2.model.InstanceType]] =
      scala
        .Option(impl.instanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.InstanceType.wrap(item)
          }.toList
        )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val productDescriptions: Option[List[String]] = scala
      .Option(impl.productDescriptions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest
  ): zio.aws.ec2.model.DescribeSpotPriceHistoryRequest.ReadOnly = new Wrapper(
    impl
  )
}
