package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeRouteTablesResponse(
    routeTables: Option[Iterable[zio.aws.ec2.model.RouteTable]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse = {
    import DescribeRouteTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse
      .builder()
      .optionallyWith(
        routeTables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.routeTables)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeRouteTablesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeRouteTablesResponse.wrap(buildAwsValue())
}
object DescribeRouteTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeRouteTablesResponse =
      zio.aws.ec2.model.DescribeRouteTablesResponse(
        routeTables.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def routeTables: Option[List[zio.aws.ec2.model.RouteTable.ReadOnly]]
    def nextToken: Option[String]
    def getRouteTables
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.RouteTable.ReadOnly]] =
      AwsError.unwrapOptionField("routeTables", routeTables)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse
  ) extends zio.aws.ec2.model.DescribeRouteTablesResponse.ReadOnly {
    override val routeTables
        : Option[List[zio.aws.ec2.model.RouteTable.ReadOnly]] = scala
      .Option(impl.routeTables())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.RouteTable.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeRouteTablesResponse
  ): zio.aws.ec2.model.DescribeRouteTablesResponse.ReadOnly = new Wrapper(impl)
}
