package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{ReservedInstancesListingId, ReservationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedInstancesListingsRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    reservedInstancesId: Option[ReservationId] = None,
    reservedInstancesListingId: Option[ReservedInstancesListingId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest = {
    import DescribeReservedInstancesListingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        reservedInstancesId.map(value =>
          ReservationId.unwrap(value): java.lang.String
        )
      )(_.reservedInstancesId)
      .optionallyWith(
        reservedInstancesListingId.map(value =>
          ReservedInstancesListingId.unwrap(value): java.lang.String
        )
      )(_.reservedInstancesListingId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeReservedInstancesListingsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeReservedInstancesListingsRequest
      .wrap(buildAwsValue())
}
object DescribeReservedInstancesListingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeReservedInstancesListingsRequest =
      zio.aws.ec2.model.DescribeReservedInstancesListingsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reservedInstancesId.map(value => value),
        reservedInstancesListingId.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def reservedInstancesId: Option[ReservationId]
    def reservedInstancesListingId: Option[ReservedInstancesListingId]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getReservedInstancesId: ZIO[Any, AwsError, ReservationId] =
      AwsError.unwrapOptionField("reservedInstancesId", reservedInstancesId)
    def getReservedInstancesListingId
        : ZIO[Any, AwsError, ReservedInstancesListingId] =
      AwsError.unwrapOptionField(
        "reservedInstancesListingId",
        reservedInstancesListingId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest
  ) extends zio.aws.ec2.model.DescribeReservedInstancesListingsRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val reservedInstancesId: Option[ReservationId] = scala
      .Option(impl.reservedInstancesId())
      .map(value => zio.aws.ec2.model.primitives.ReservationId(value))
    override val reservedInstancesListingId
        : Option[ReservedInstancesListingId] = scala
      .Option(impl.reservedInstancesListingId())
      .map(value =>
        zio.aws.ec2.model.primitives.ReservedInstancesListingId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesListingsRequest
  ): zio.aws.ec2.model.DescribeReservedInstancesListingsRequest.ReadOnly =
    new Wrapper(impl)
}
