package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeNetworkInterfacesMaxResults,
  NetworkInterfaceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeNetworkInterfacesRequest(
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    networkInterfaceIds: Option[Iterable[NetworkInterfaceId]] = None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeNetworkInterfacesMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest = {
    import DescribeNetworkInterfacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        networkInterfaceIds.map(value =>
          value.map { item =>
            NetworkInterfaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfaceIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeNetworkInterfacesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeNetworkInterfacesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeNetworkInterfacesRequest.wrap(buildAwsValue())
}
object DescribeNetworkInterfacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeNetworkInterfacesRequest =
      zio.aws.ec2.model.DescribeNetworkInterfacesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaceIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def networkInterfaceIds: Option[List[NetworkInterfaceId]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeNetworkInterfacesMaxResults]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNetworkInterfaceIds: ZIO[Any, AwsError, List[NetworkInterfaceId]] =
      AwsError.unwrapOptionField("networkInterfaceIds", networkInterfaceIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, DescribeNetworkInterfacesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest
  ) extends zio.aws.ec2.model.DescribeNetworkInterfacesRequest.ReadOnly {
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val networkInterfaceIds: Option[List[NetworkInterfaceId]] = scala
      .Option(impl.networkInterfaceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.NetworkInterfaceId(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[DescribeNetworkInterfacesMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.DescribeNetworkInterfacesMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest
  ): zio.aws.ec2.model.DescribeNetworkInterfacesRequest.ReadOnly = new Wrapper(
    impl
  )
}
