package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  LocalGatewayMaxResults,
  LocalGatewayVirtualInterfaceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLocalGatewayVirtualInterfacesRequest(
    localGatewayVirtualInterfaceIds: Option[
      Iterable[LocalGatewayVirtualInterfaceId]
    ] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    maxResults: Option[LocalGatewayMaxResults] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest = {
    import DescribeLocalGatewayVirtualInterfacesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest
      .builder()
      .optionallyWith(
        localGatewayVirtualInterfaceIds.map(value =>
          value.map { item =>
            LocalGatewayVirtualInterfaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.localGatewayVirtualInterfaceIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => LocalGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest
      .wrap(buildAwsValue())
}
object DescribeLocalGatewayVirtualInterfacesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest =
      zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest(
        localGatewayVirtualInterfaceIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def localGatewayVirtualInterfaceIds
        : Option[List[LocalGatewayVirtualInterfaceId]]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def maxResults: Option[LocalGatewayMaxResults]
    def nextToken: Option[String]
    def getLocalGatewayVirtualInterfaceIds
        : ZIO[Any, AwsError, List[LocalGatewayVirtualInterfaceId]] =
      AwsError.unwrapOptionField(
        "localGatewayVirtualInterfaceIds",
        localGatewayVirtualInterfaceIds
      )
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, LocalGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest
  ) extends zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest.ReadOnly {
    override val localGatewayVirtualInterfaceIds
        : Option[List[LocalGatewayVirtualInterfaceId]] = scala
      .Option(impl.localGatewayVirtualInterfaceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceId(item)
        }.toList
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Option[LocalGatewayMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.LocalGatewayMaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest
  ): zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest.ReadOnly =
    new Wrapper(impl)
}
