package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  Integer,
  LaunchTemplateName,
  LaunchTemplateId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLaunchTemplateVersionsRequest(
    launchTemplateId: Option[LaunchTemplateId] = None,
    launchTemplateName: Option[LaunchTemplateName] = None,
    versions: Option[Iterable[String]] = None,
    minVersion: Option[String] = None,
    maxVersion: Option[String] = None,
    nextToken: Option[String] = None,
    maxResults: Option[Integer] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest = {
    import DescribeLaunchTemplateVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest
      .builder()
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(
        versions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.versions)
      .optionallyWith(minVersion.map(value => value: java.lang.String))(
        _.minVersion
      )
      .optionallyWith(maxVersion.map(value => value: java.lang.String))(
        _.maxVersion
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest
      .wrap(buildAwsValue())
}
object DescribeLaunchTemplateVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest =
      zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        versions.map(value => value),
        minVersion.map(value => value),
        maxVersion.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def launchTemplateId: Option[LaunchTemplateId]
    def launchTemplateName: Option[LaunchTemplateName]
    def versions: Option[List[String]]
    def minVersion: Option[String]
    def maxVersion: Option[String]
    def nextToken: Option[String]
    def maxResults: Option[Integer]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("versions", versions)
    def getMinVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("minVersion", minVersion)
    def getMaxVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxVersion", maxVersion)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest
  ) extends zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest.ReadOnly {
    override val launchTemplateId: Option[LaunchTemplateId] = scala
      .Option(impl.launchTemplateId())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Option[LaunchTemplateName] = scala
      .Option(impl.launchTemplateName())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val versions: Option[List[String]] = scala
      .Option(impl.versions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val minVersion: Option[String] =
      scala.Option(impl.minVersion()).map(value => value: String)
    override val maxVersion: Option[String] =
      scala.Option(impl.maxVersion()).map(value => value: String)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeLaunchTemplateVersionsRequest
  ): zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
