package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeInstancesResponse(
    reservations: Option[Iterable[zio.aws.ec2.model.Reservation]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse = {
    import DescribeInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse
      .builder()
      .optionallyWith(
        reservations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInstancesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeInstancesResponse.wrap(buildAwsValue())
}
object DescribeInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstancesResponse =
      zio.aws.ec2.model.DescribeInstancesResponse(
        reservations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def reservations: Option[List[zio.aws.ec2.model.Reservation.ReadOnly]]
    def nextToken: Option[String]
    def getReservations
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Reservation.ReadOnly]] =
      AwsError.unwrapOptionField("reservations", reservations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse
  ) extends zio.aws.ec2.model.DescribeInstancesResponse.ReadOnly {
    override val reservations
        : Option[List[zio.aws.ec2.model.Reservation.ReadOnly]] = scala
      .Option(impl.reservations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Reservation.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse
  ): zio.aws.ec2.model.DescribeInstancesResponse.ReadOnly = new Wrapper(impl)
}
