package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFastSnapshotRestoresResponse(
    fastSnapshotRestores: Option[
      Iterable[zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse = {
    import DescribeFastSnapshotRestoresResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse
      .builder()
      .optionallyWith(
        fastSnapshotRestores.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fastSnapshotRestores)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse.ReadOnly =
    zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse.wrap(buildAwsValue())
}
object DescribeFastSnapshotRestoresResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse =
      zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse(
        fastSnapshotRestores.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fastSnapshotRestores: Option[
      List[zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getFastSnapshotRestores: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem.ReadOnly
    ]] =
      AwsError.unwrapOptionField("fastSnapshotRestores", fastSnapshotRestores)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse
  ) extends zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse.ReadOnly {
    override val fastSnapshotRestores: Option[
      List[zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem.ReadOnly]
    ] = scala
      .Option(impl.fastSnapshotRestores())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFastSnapshotRestoresResponse
  ): zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse.ReadOnly =
    new Wrapper(impl)
}
