package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  DescribeCapacityReservationFleetsMaxResults,
  CapacityReservationFleetId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeCapacityReservationFleetsRequest(
    capacityReservationFleetIds: Option[Iterable[CapacityReservationFleetId]] =
      None,
    nextToken: Option[String] = None,
    maxResults: Option[DescribeCapacityReservationFleetsMaxResults] = None,
    filters: Option[Iterable[zio.aws.ec2.model.Filter]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest = {
    import DescribeCapacityReservationFleetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest
      .builder()
      .optionallyWith(
        capacityReservationFleetIds.map(value =>
          value.map { item =>
            CapacityReservationFleetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.capacityReservationFleetIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          DescribeCapacityReservationFleetsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest
      .wrap(buildAwsValue())
}
object DescribeCapacityReservationFleetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest =
      zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest(
        capacityReservationFleetIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def capacityReservationFleetIds: Option[List[CapacityReservationFleetId]]
    def nextToken: Option[String]
    def maxResults: Option[DescribeCapacityReservationFleetsMaxResults]
    def filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getCapacityReservationFleetIds
        : ZIO[Any, AwsError, List[CapacityReservationFleetId]] =
      AwsError.unwrapOptionField(
        "capacityReservationFleetIds",
        capacityReservationFleetIds
      )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeCapacityReservationFleetsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest
  ) extends zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest.ReadOnly {
    override val capacityReservationFleetIds
        : Option[List[CapacityReservationFleetId]] = scala
      .Option(impl.capacityReservationFleetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.CapacityReservationFleetId(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults
        : Option[DescribeCapacityReservationFleetsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives
          .DescribeCapacityReservationFleetsMaxResults(value)
      )
    override val filters: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationFleetsRequest
  ): zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest.ReadOnly =
    new Wrapper(impl)
}
