package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeprovisionIpamPoolCidrResponse(
    ipamPoolCidr: Option[zio.aws.ec2.model.IpamPoolCidr] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrResponse = {
    import DeprovisionIpamPoolCidrResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrResponse
      .builder()
      .optionallyWith(ipamPoolCidr.map(value => value.buildAwsValue()))(
        _.ipamPoolCidr
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse.ReadOnly =
    zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse.wrap(buildAwsValue())
}
object DeprovisionIpamPoolCidrResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse =
      zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse(
        ipamPoolCidr.map(value => value.asEditable)
      )
    def ipamPoolCidr: Option[zio.aws.ec2.model.IpamPoolCidr.ReadOnly]
    def getIpamPoolCidr
        : ZIO[Any, AwsError, zio.aws.ec2.model.IpamPoolCidr.ReadOnly] =
      AwsError.unwrapOptionField("ipamPoolCidr", ipamPoolCidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrResponse
  ) extends zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse.ReadOnly {
    override val ipamPoolCidr: Option[zio.aws.ec2.model.IpamPoolCidr.ReadOnly] =
      scala
        .Option(impl.ipamPoolCidr())
        .map(value => zio.aws.ec2.model.IpamPoolCidr.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeprovisionIpamPoolCidrResponse
  ): zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse.ReadOnly = new Wrapper(
    impl
  )
}
