package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayRouteResponse(
    route: Option[zio.aws.ec2.model.TransitGatewayRoute] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteResponse = {
    import DeleteTransitGatewayRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteResponse
      .builder()
      .optionallyWith(route.map(value => value.buildAwsValue()))(_.route)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTransitGatewayRouteResponse.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayRouteResponse.wrap(buildAwsValue())
}
object DeleteTransitGatewayRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTransitGatewayRouteResponse =
      zio.aws.ec2.model
        .DeleteTransitGatewayRouteResponse(route.map(value => value.asEditable))
    def route: Option[zio.aws.ec2.model.TransitGatewayRoute.ReadOnly]
    def getRoute
        : ZIO[Any, AwsError, zio.aws.ec2.model.TransitGatewayRoute.ReadOnly] =
      AwsError.unwrapOptionField("route", route)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteResponse
  ) extends zio.aws.ec2.model.DeleteTransitGatewayRouteResponse.ReadOnly {
    override val route: Option[zio.aws.ec2.model.TransitGatewayRoute.ReadOnly] =
      scala
        .Option(impl.route())
        .map(value => zio.aws.ec2.model.TransitGatewayRoute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteResponse
  ): zio.aws.ec2.model.DeleteTransitGatewayRouteResponse.ReadOnly = new Wrapper(
    impl
  )
}
