package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TrafficMirrorFilterRuleId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorFilterRuleRequest(
    trafficMirrorFilterRuleId: TrafficMirrorFilterRuleId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest = {
    import DeleteTrafficMirrorFilterRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
      .builder()
      .trafficMirrorFilterRuleId(
        TrafficMirrorFilterRuleId.unwrap(
          trafficMirrorFilterRuleId
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.wrap(buildAwsValue())
}
object DeleteTrafficMirrorFilterRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest =
      zio.aws.ec2.model
        .DeleteTrafficMirrorFilterRuleRequest(trafficMirrorFilterRuleId)
    def trafficMirrorFilterRuleId: TrafficMirrorFilterRuleId
    def getTrafficMirrorFilterRuleId
        : ZIO[Any, Nothing, TrafficMirrorFilterRuleId] =
      ZIO.succeed(trafficMirrorFilterRuleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.ReadOnly {
    override val trafficMirrorFilterRuleId: TrafficMirrorFilterRuleId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorFilterRuleId(impl.trafficMirrorFilterRuleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRuleRequest
  ): zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest.ReadOnly =
    new Wrapper(impl)
}
