package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteEgressOnlyInternetGatewayResponse(
    returnCode: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayResponse = {
    import DeleteEgressOnlyInternetGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayResponse
      .builder()
      .optionallyWith(returnCode.map(value => value: java.lang.Boolean))(
        _.returnCode
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayResponse.ReadOnly =
    zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayResponse
      .wrap(buildAwsValue())
}
object DeleteEgressOnlyInternetGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayResponse =
      zio.aws.ec2.model
        .DeleteEgressOnlyInternetGatewayResponse(returnCode.map(value => value))
    def returnCode: Option[Boolean]
    def getReturnCode: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("returnCode", returnCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayResponse
  ) extends zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayResponse.ReadOnly {
    override val returnCode: Option[Boolean] =
      scala.Option(impl.returnCode()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteEgressOnlyInternetGatewayResponse
  ): zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
