package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelSpotFleetRequestsResponse(
    successfulFleetRequests: Option[
      Iterable[zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem]
    ] = None,
    unsuccessfulFleetRequests: Option[
      Iterable[zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsResponse = {
    import CancelSpotFleetRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsResponse
      .builder()
      .optionallyWith(
        successfulFleetRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successfulFleetRequests)
      .optionallyWith(
        unsuccessfulFleetRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unsuccessfulFleetRequests)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CancelSpotFleetRequestsResponse.ReadOnly =
    zio.aws.ec2.model.CancelSpotFleetRequestsResponse.wrap(buildAwsValue())
}
object CancelSpotFleetRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelSpotFleetRequestsResponse =
      zio.aws.ec2.model.CancelSpotFleetRequestsResponse(
        successfulFleetRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unsuccessfulFleetRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successfulFleetRequests: Option[
      List[zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem.ReadOnly]
    ]
    def unsuccessfulFleetRequests: Option[
      List[zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem.ReadOnly]
    ]
    def getSuccessfulFleetRequests: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "successfulFleetRequests",
      successfulFleetRequests
    )
    def getUnsuccessfulFleetRequests: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unsuccessfulFleetRequests",
      unsuccessfulFleetRequests
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsResponse
  ) extends zio.aws.ec2.model.CancelSpotFleetRequestsResponse.ReadOnly {
    override val successfulFleetRequests: Option[
      List[zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem.ReadOnly]
    ] = scala
      .Option(impl.successfulFleetRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.CancelSpotFleetRequestsSuccessItem.wrap(item)
        }.toList
      )
    override val unsuccessfulFleetRequests: Option[
      List[zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem.ReadOnly]
    ] = scala
      .Option(impl.unsuccessfulFleetRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.CancelSpotFleetRequestsErrorItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsResponse
  ): zio.aws.ec2.model.CancelSpotFleetRequestsResponse.ReadOnly = new Wrapper(
    impl
  )
}
