package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AvailabilityZone(
    state: Option[zio.aws.ec2.model.AvailabilityZoneState] = None,
    optInStatus: Option[zio.aws.ec2.model.AvailabilityZoneOptInStatus] = None,
    messages: Option[Iterable[zio.aws.ec2.model.AvailabilityZoneMessage]] =
      None,
    regionName: Option[String] = None,
    zoneName: Option[String] = None,
    zoneId: Option[String] = None,
    groupName: Option[String] = None,
    networkBorderGroup: Option[String] = None,
    zoneType: Option[String] = None,
    parentZoneName: Option[String] = None,
    parentZoneId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AvailabilityZone
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(optInStatus.map(value => value.unwrap))(_.optInStatus)
      .optionallyWith(
        messages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.messages)
      .optionallyWith(regionName.map(value => value: java.lang.String))(
        _.regionName
      )
      .optionallyWith(zoneName.map(value => value: java.lang.String))(
        _.zoneName
      )
      .optionallyWith(zoneId.map(value => value: java.lang.String))(_.zoneId)
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(networkBorderGroup.map(value => value: java.lang.String))(
        _.networkBorderGroup
      )
      .optionallyWith(zoneType.map(value => value: java.lang.String))(
        _.zoneType
      )
      .optionallyWith(parentZoneName.map(value => value: java.lang.String))(
        _.parentZoneName
      )
      .optionallyWith(parentZoneId.map(value => value: java.lang.String))(
        _.parentZoneId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AvailabilityZone.ReadOnly =
    zio.aws.ec2.model.AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AvailabilityZone =
      zio.aws.ec2.model.AvailabilityZone(
        state.map(value => value),
        optInStatus.map(value => value),
        messages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        regionName.map(value => value),
        zoneName.map(value => value),
        zoneId.map(value => value),
        groupName.map(value => value),
        networkBorderGroup.map(value => value),
        zoneType.map(value => value),
        parentZoneName.map(value => value),
        parentZoneId.map(value => value)
      )
    def state: Option[zio.aws.ec2.model.AvailabilityZoneState]
    def optInStatus: Option[zio.aws.ec2.model.AvailabilityZoneOptInStatus]
    def messages
        : Option[List[zio.aws.ec2.model.AvailabilityZoneMessage.ReadOnly]]
    def regionName: Option[String]
    def zoneName: Option[String]
    def zoneId: Option[String]
    def groupName: Option[String]
    def networkBorderGroup: Option[String]
    def zoneType: Option[String]
    def parentZoneName: Option[String]
    def parentZoneId: Option[String]
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.AvailabilityZoneState] =
      AwsError.unwrapOptionField("state", state)
    def getOptInStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.AvailabilityZoneOptInStatus] =
      AwsError.unwrapOptionField("optInStatus", optInStatus)
    def getMessages: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AvailabilityZoneMessage.ReadOnly
    ]] = AwsError.unwrapOptionField("messages", messages)
    def getRegionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getZoneName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("zoneName", zoneName)
    def getZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("zoneId", zoneId)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getNetworkBorderGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkBorderGroup", networkBorderGroup)
    def getZoneType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("zoneType", zoneType)
    def getParentZoneName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parentZoneName", parentZoneName)
    def getParentZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parentZoneId", parentZoneId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AvailabilityZone
  ) extends zio.aws.ec2.model.AvailabilityZone.ReadOnly {
    override val state: Option[zio.aws.ec2.model.AvailabilityZoneState] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.AvailabilityZoneState.wrap(value))
    override val optInStatus
        : Option[zio.aws.ec2.model.AvailabilityZoneOptInStatus] = scala
      .Option(impl.optInStatus())
      .map(value => zio.aws.ec2.model.AvailabilityZoneOptInStatus.wrap(value))
    override val messages
        : Option[List[zio.aws.ec2.model.AvailabilityZoneMessage.ReadOnly]] =
      scala
        .Option(impl.messages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AvailabilityZoneMessage.wrap(item)
          }.toList
        )
    override val regionName: Option[String] =
      scala.Option(impl.regionName()).map(value => value: String)
    override val zoneName: Option[String] =
      scala.Option(impl.zoneName()).map(value => value: String)
    override val zoneId: Option[String] =
      scala.Option(impl.zoneId()).map(value => value: String)
    override val groupName: Option[String] =
      scala.Option(impl.groupName()).map(value => value: String)
    override val networkBorderGroup: Option[String] =
      scala.Option(impl.networkBorderGroup()).map(value => value: String)
    override val zoneType: Option[String] =
      scala.Option(impl.zoneType()).map(value => value: String)
    override val parentZoneName: Option[String] =
      scala.Option(impl.parentZoneName()).map(value => value: String)
    override val parentZoneId: Option[String] =
      scala.Option(impl.parentZoneId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AvailabilityZone
  ): zio.aws.ec2.model.AvailabilityZone.ReadOnly = new Wrapper(impl)
}
