package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociatedRole(
    associatedRoleArn: Option[ResourceArn] = None,
    certificateS3BucketName: Option[String] = None,
    certificateS3ObjectKey: Option[String] = None,
    encryptionKmsKeyId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociatedRole = {
    import AssociatedRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociatedRole
      .builder()
      .optionallyWith(
        associatedRoleArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.associatedRoleArn)
      .optionallyWith(
        certificateS3BucketName.map(value => value: java.lang.String)
      )(_.certificateS3BucketName)
      .optionallyWith(
        certificateS3ObjectKey.map(value => value: java.lang.String)
      )(_.certificateS3ObjectKey)
      .optionallyWith(encryptionKmsKeyId.map(value => value: java.lang.String))(
        _.encryptionKmsKeyId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociatedRole.ReadOnly =
    zio.aws.ec2.model.AssociatedRole.wrap(buildAwsValue())
}
object AssociatedRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociatedRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociatedRole =
      zio.aws.ec2.model.AssociatedRole(
        associatedRoleArn.map(value => value),
        certificateS3BucketName.map(value => value),
        certificateS3ObjectKey.map(value => value),
        encryptionKmsKeyId.map(value => value)
      )
    def associatedRoleArn: Option[ResourceArn]
    def certificateS3BucketName: Option[String]
    def certificateS3ObjectKey: Option[String]
    def encryptionKmsKeyId: Option[String]
    def getAssociatedRoleArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("associatedRoleArn", associatedRoleArn)
    def getCertificateS3BucketName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("certificateS3BucketName", certificateS3BucketName)
    def getCertificateS3ObjectKey: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("certificateS3ObjectKey", certificateS3ObjectKey)
    def getEncryptionKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encryptionKmsKeyId", encryptionKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociatedRole
  ) extends zio.aws.ec2.model.AssociatedRole.ReadOnly {
    override val associatedRoleArn: Option[ResourceArn] = scala
      .Option(impl.associatedRoleArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val certificateS3BucketName: Option[String] =
      scala.Option(impl.certificateS3BucketName()).map(value => value: String)
    override val certificateS3ObjectKey: Option[String] =
      scala.Option(impl.certificateS3ObjectKey()).map(value => value: String)
    override val encryptionKmsKeyId: Option[String] =
      scala.Option(impl.encryptionKmsKeyId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociatedRole
  ): zio.aws.ec2.model.AssociatedRole.ReadOnly = new Wrapper(impl)
}
