package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AllocateAddressResponse(
    publicIp: Option[String] = None,
    allocationId: Option[String] = None,
    publicIpv4Pool: Option[String] = None,
    networkBorderGroup: Option[String] = None,
    domain: Option[zio.aws.ec2.model.DomainType] = None,
    customerOwnedIp: Option[String] = None,
    customerOwnedIpv4Pool: Option[String] = None,
    carrierIp: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AllocateAddressResponse = {
    import AllocateAddressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AllocateAddressResponse
      .builder()
      .optionallyWith(publicIp.map(value => value: java.lang.String))(
        _.publicIp
      )
      .optionallyWith(allocationId.map(value => value: java.lang.String))(
        _.allocationId
      )
      .optionallyWith(publicIpv4Pool.map(value => value: java.lang.String))(
        _.publicIpv4Pool
      )
      .optionallyWith(networkBorderGroup.map(value => value: java.lang.String))(
        _.networkBorderGroup
      )
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(customerOwnedIp.map(value => value: java.lang.String))(
        _.customerOwnedIp
      )
      .optionallyWith(
        customerOwnedIpv4Pool.map(value => value: java.lang.String)
      )(_.customerOwnedIpv4Pool)
      .optionallyWith(carrierIp.map(value => value: java.lang.String))(
        _.carrierIp
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AllocateAddressResponse.ReadOnly =
    zio.aws.ec2.model.AllocateAddressResponse.wrap(buildAwsValue())
}
object AllocateAddressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AllocateAddressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AllocateAddressResponse =
      zio.aws.ec2.model.AllocateAddressResponse(
        publicIp.map(value => value),
        allocationId.map(value => value),
        publicIpv4Pool.map(value => value),
        networkBorderGroup.map(value => value),
        domain.map(value => value),
        customerOwnedIp.map(value => value),
        customerOwnedIpv4Pool.map(value => value),
        carrierIp.map(value => value)
      )
    def publicIp: Option[String]
    def allocationId: Option[String]
    def publicIpv4Pool: Option[String]
    def networkBorderGroup: Option[String]
    def domain: Option[zio.aws.ec2.model.DomainType]
    def customerOwnedIp: Option[String]
    def customerOwnedIpv4Pool: Option[String]
    def carrierIp: Option[String]
    def getPublicIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getAllocationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getPublicIpv4Pool: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("publicIpv4Pool", publicIpv4Pool)
    def getNetworkBorderGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkBorderGroup", networkBorderGroup)
    def getDomain: ZIO[Any, AwsError, zio.aws.ec2.model.DomainType] =
      AwsError.unwrapOptionField("domain", domain)
    def getCustomerOwnedIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerOwnedIp", customerOwnedIp)
    def getCustomerOwnedIpv4Pool: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customerOwnedIpv4Pool", customerOwnedIpv4Pool)
    def getCarrierIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("carrierIp", carrierIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AllocateAddressResponse
  ) extends zio.aws.ec2.model.AllocateAddressResponse.ReadOnly {
    override val publicIp: Option[String] =
      scala.Option(impl.publicIp()).map(value => value: String)
    override val allocationId: Option[String] =
      scala.Option(impl.allocationId()).map(value => value: String)
    override val publicIpv4Pool: Option[String] =
      scala.Option(impl.publicIpv4Pool()).map(value => value: String)
    override val networkBorderGroup: Option[String] =
      scala.Option(impl.networkBorderGroup()).map(value => value: String)
    override val domain: Option[zio.aws.ec2.model.DomainType] = scala
      .Option(impl.domain())
      .map(value => zio.aws.ec2.model.DomainType.wrap(value))
    override val customerOwnedIp: Option[String] =
      scala.Option(impl.customerOwnedIp()).map(value => value: String)
    override val customerOwnedIpv4Pool: Option[String] =
      scala.Option(impl.customerOwnedIpv4Pool()).map(value => value: String)
    override val carrierIp: Option[String] =
      scala.Option(impl.carrierIp()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AllocateAddressResponse
  ): zio.aws.ec2.model.AllocateAddressResponse.ReadOnly = new Wrapper(impl)
}
