package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NetworkInterfaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UnassignIpv6AddressesRequest(
    ipv6Addresses: Option[Iterable[String]] = None,
    ipv6Prefixes: Option[Iterable[String]] = None,
    networkInterfaceId: NetworkInterfaceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest = {
    import UnassignIpv6AddressesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest
      .builder()
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(
        ipv6Prefixes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Prefixes)
      .networkInterfaceId(
        NetworkInterfaceId.unwrap(networkInterfaceId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.UnassignIpv6AddressesRequest.ReadOnly =
    zio.aws.ec2.model.UnassignIpv6AddressesRequest.wrap(buildAwsValue())
}
object UnassignIpv6AddressesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.UnassignIpv6AddressesRequest =
      zio.aws.ec2.model.UnassignIpv6AddressesRequest(
        ipv6Addresses.map(value => value),
        ipv6Prefixes.map(value => value),
        networkInterfaceId
      )
    def ipv6Addresses: Option[List[String]]
    def ipv6Prefixes: Option[List[String]]
    def networkInterfaceId: NetworkInterfaceId
    def getIpv6Addresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getIpv6Prefixes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv6Prefixes", ipv6Prefixes)
    def getNetworkInterfaceId: ZIO[Any, Nothing, NetworkInterfaceId] =
      ZIO.succeed(networkInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest
  ) extends zio.aws.ec2.model.UnassignIpv6AddressesRequest.ReadOnly {
    override val ipv6Addresses: Option[List[String]] = scala
      .Option(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ipv6Prefixes: Option[List[String]] = scala
      .Option(impl.ipv6Prefixes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val networkInterfaceId: NetworkInterfaceId =
      zio.aws.ec2.model.primitives.NetworkInterfaceId(impl.networkInterfaceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.UnassignIpv6AddressesRequest
  ): zio.aws.ec2.model.UnassignIpv6AddressesRequest.ReadOnly = new Wrapper(impl)
}
