package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TunnelOption(
    outsideIpAddress: Option[String] = None,
    tunnelInsideCidr: Option[String] = None,
    tunnelInsideIpv6Cidr: Option[String] = None,
    preSharedKey: Option[String] = None,
    phase1LifetimeSeconds: Option[Integer] = None,
    phase2LifetimeSeconds: Option[Integer] = None,
    rekeyMarginTimeSeconds: Option[Integer] = None,
    rekeyFuzzPercentage: Option[Integer] = None,
    replayWindowSize: Option[Integer] = None,
    dpdTimeoutSeconds: Option[Integer] = None,
    dpdTimeoutAction: Option[String] = None,
    phase1EncryptionAlgorithms: Option[
      Iterable[zio.aws.ec2.model.Phase1EncryptionAlgorithmsListValue]
    ] = None,
    phase2EncryptionAlgorithms: Option[
      Iterable[zio.aws.ec2.model.Phase2EncryptionAlgorithmsListValue]
    ] = None,
    phase1IntegrityAlgorithms: Option[
      Iterable[zio.aws.ec2.model.Phase1IntegrityAlgorithmsListValue]
    ] = None,
    phase2IntegrityAlgorithms: Option[
      Iterable[zio.aws.ec2.model.Phase2IntegrityAlgorithmsListValue]
    ] = None,
    phase1DHGroupNumbers: Option[
      Iterable[zio.aws.ec2.model.Phase1DHGroupNumbersListValue]
    ] = None,
    phase2DHGroupNumbers: Option[
      Iterable[zio.aws.ec2.model.Phase2DHGroupNumbersListValue]
    ] = None,
    ikeVersions: Option[Iterable[zio.aws.ec2.model.IKEVersionsListValue]] =
      None,
    startupAction: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TunnelOption = {
    import TunnelOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TunnelOption
      .builder()
      .optionallyWith(outsideIpAddress.map(value => value: java.lang.String))(
        _.outsideIpAddress
      )
      .optionallyWith(tunnelInsideCidr.map(value => value: java.lang.String))(
        _.tunnelInsideCidr
      )
      .optionallyWith(
        tunnelInsideIpv6Cidr.map(value => value: java.lang.String)
      )(_.tunnelInsideIpv6Cidr)
      .optionallyWith(preSharedKey.map(value => value: java.lang.String))(
        _.preSharedKey
      )
      .optionallyWith(
        phase1LifetimeSeconds.map(value => value: java.lang.Integer)
      )(_.phase1LifetimeSeconds)
      .optionallyWith(
        phase2LifetimeSeconds.map(value => value: java.lang.Integer)
      )(_.phase2LifetimeSeconds)
      .optionallyWith(
        rekeyMarginTimeSeconds.map(value => value: java.lang.Integer)
      )(_.rekeyMarginTimeSeconds)
      .optionallyWith(
        rekeyFuzzPercentage.map(value => value: java.lang.Integer)
      )(_.rekeyFuzzPercentage)
      .optionallyWith(replayWindowSize.map(value => value: java.lang.Integer))(
        _.replayWindowSize
      )
      .optionallyWith(dpdTimeoutSeconds.map(value => value: java.lang.Integer))(
        _.dpdTimeoutSeconds
      )
      .optionallyWith(dpdTimeoutAction.map(value => value: java.lang.String))(
        _.dpdTimeoutAction
      )
      .optionallyWith(
        phase1EncryptionAlgorithms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase1EncryptionAlgorithms)
      .optionallyWith(
        phase2EncryptionAlgorithms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase2EncryptionAlgorithms)
      .optionallyWith(
        phase1IntegrityAlgorithms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase1IntegrityAlgorithms)
      .optionallyWith(
        phase2IntegrityAlgorithms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase2IntegrityAlgorithms)
      .optionallyWith(
        phase1DHGroupNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase1DHGroupNumbers)
      .optionallyWith(
        phase2DHGroupNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phase2DHGroupNumbers)
      .optionallyWith(
        ikeVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ikeVersions)
      .optionallyWith(startupAction.map(value => value: java.lang.String))(
        _.startupAction
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TunnelOption.ReadOnly =
    zio.aws.ec2.model.TunnelOption.wrap(buildAwsValue())
}
object TunnelOption {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.TunnelOption] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TunnelOption =
      zio.aws.ec2.model.TunnelOption(
        outsideIpAddress.map(value => value),
        tunnelInsideCidr.map(value => value),
        tunnelInsideIpv6Cidr.map(value => value),
        preSharedKey.map(value => value),
        phase1LifetimeSeconds.map(value => value),
        phase2LifetimeSeconds.map(value => value),
        rekeyMarginTimeSeconds.map(value => value),
        rekeyFuzzPercentage.map(value => value),
        replayWindowSize.map(value => value),
        dpdTimeoutSeconds.map(value => value),
        dpdTimeoutAction.map(value => value),
        phase1EncryptionAlgorithms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        phase2EncryptionAlgorithms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        phase1IntegrityAlgorithms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        phase2IntegrityAlgorithms.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        phase1DHGroupNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        phase2DHGroupNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ikeVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startupAction.map(value => value)
      )
    def outsideIpAddress: Option[String]
    def tunnelInsideCidr: Option[String]
    def tunnelInsideIpv6Cidr: Option[String]
    def preSharedKey: Option[String]
    def phase1LifetimeSeconds: Option[Integer]
    def phase2LifetimeSeconds: Option[Integer]
    def rekeyMarginTimeSeconds: Option[Integer]
    def rekeyFuzzPercentage: Option[Integer]
    def replayWindowSize: Option[Integer]
    def dpdTimeoutSeconds: Option[Integer]
    def dpdTimeoutAction: Option[String]
    def phase1EncryptionAlgorithms: Option[
      List[zio.aws.ec2.model.Phase1EncryptionAlgorithmsListValue.ReadOnly]
    ]
    def phase2EncryptionAlgorithms: Option[
      List[zio.aws.ec2.model.Phase2EncryptionAlgorithmsListValue.ReadOnly]
    ]
    def phase1IntegrityAlgorithms: Option[
      List[zio.aws.ec2.model.Phase1IntegrityAlgorithmsListValue.ReadOnly]
    ]
    def phase2IntegrityAlgorithms: Option[
      List[zio.aws.ec2.model.Phase2IntegrityAlgorithmsListValue.ReadOnly]
    ]
    def phase1DHGroupNumbers
        : Option[List[zio.aws.ec2.model.Phase1DHGroupNumbersListValue.ReadOnly]]
    def phase2DHGroupNumbers
        : Option[List[zio.aws.ec2.model.Phase2DHGroupNumbersListValue.ReadOnly]]
    def ikeVersions
        : Option[List[zio.aws.ec2.model.IKEVersionsListValue.ReadOnly]]
    def startupAction: Option[String]
    def getOutsideIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outsideIpAddress", outsideIpAddress)
    def getTunnelInsideCidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tunnelInsideCidr", tunnelInsideCidr)
    def getTunnelInsideIpv6Cidr: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tunnelInsideIpv6Cidr", tunnelInsideIpv6Cidr)
    def getPreSharedKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSharedKey", preSharedKey)
    def getPhase1LifetimeSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("phase1LifetimeSeconds", phase1LifetimeSeconds)
    def getPhase2LifetimeSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("phase2LifetimeSeconds", phase2LifetimeSeconds)
    def getRekeyMarginTimeSeconds: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("rekeyMarginTimeSeconds", rekeyMarginTimeSeconds)
    def getRekeyFuzzPercentage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("rekeyFuzzPercentage", rekeyFuzzPercentage)
    def getReplayWindowSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("replayWindowSize", replayWindowSize)
    def getDpdTimeoutSeconds: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dpdTimeoutSeconds", dpdTimeoutSeconds)
    def getDpdTimeoutAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dpdTimeoutAction", dpdTimeoutAction)
    def getPhase1EncryptionAlgorithms: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase1EncryptionAlgorithmsListValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "phase1EncryptionAlgorithms",
      phase1EncryptionAlgorithms
    )
    def getPhase2EncryptionAlgorithms: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase2EncryptionAlgorithmsListValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "phase2EncryptionAlgorithms",
      phase2EncryptionAlgorithms
    )
    def getPhase1IntegrityAlgorithms: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase1IntegrityAlgorithmsListValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "phase1IntegrityAlgorithms",
      phase1IntegrityAlgorithms
    )
    def getPhase2IntegrityAlgorithms: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase2IntegrityAlgorithmsListValue.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "phase2IntegrityAlgorithms",
      phase2IntegrityAlgorithms
    )
    def getPhase1DHGroupNumbers: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase1DHGroupNumbersListValue.ReadOnly
    ]] =
      AwsError.unwrapOptionField("phase1DHGroupNumbers", phase1DHGroupNumbers)
    def getPhase2DHGroupNumbers: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.Phase2DHGroupNumbersListValue.ReadOnly
    ]] =
      AwsError.unwrapOptionField("phase2DHGroupNumbers", phase2DHGroupNumbers)
    def getIkeVersions: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.IKEVersionsListValue.ReadOnly
    ]] = AwsError.unwrapOptionField("ikeVersions", ikeVersions)
    def getStartupAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startupAction", startupAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TunnelOption
  ) extends zio.aws.ec2.model.TunnelOption.ReadOnly {
    override val outsideIpAddress: Option[String] =
      scala.Option(impl.outsideIpAddress()).map(value => value: String)
    override val tunnelInsideCidr: Option[String] =
      scala.Option(impl.tunnelInsideCidr()).map(value => value: String)
    override val tunnelInsideIpv6Cidr: Option[String] =
      scala.Option(impl.tunnelInsideIpv6Cidr()).map(value => value: String)
    override val preSharedKey: Option[String] =
      scala.Option(impl.preSharedKey()).map(value => value: String)
    override val phase1LifetimeSeconds: Option[Integer] =
      scala.Option(impl.phase1LifetimeSeconds()).map(value => value: Integer)
    override val phase2LifetimeSeconds: Option[Integer] =
      scala.Option(impl.phase2LifetimeSeconds()).map(value => value: Integer)
    override val rekeyMarginTimeSeconds: Option[Integer] =
      scala.Option(impl.rekeyMarginTimeSeconds()).map(value => value: Integer)
    override val rekeyFuzzPercentage: Option[Integer] =
      scala.Option(impl.rekeyFuzzPercentage()).map(value => value: Integer)
    override val replayWindowSize: Option[Integer] =
      scala.Option(impl.replayWindowSize()).map(value => value: Integer)
    override val dpdTimeoutSeconds: Option[Integer] =
      scala.Option(impl.dpdTimeoutSeconds()).map(value => value: Integer)
    override val dpdTimeoutAction: Option[String] =
      scala.Option(impl.dpdTimeoutAction()).map(value => value: String)
    override val phase1EncryptionAlgorithms: Option[
      List[zio.aws.ec2.model.Phase1EncryptionAlgorithmsListValue.ReadOnly]
    ] = scala
      .Option(impl.phase1EncryptionAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase1EncryptionAlgorithmsListValue.wrap(item)
        }.toList
      )
    override val phase2EncryptionAlgorithms: Option[
      List[zio.aws.ec2.model.Phase2EncryptionAlgorithmsListValue.ReadOnly]
    ] = scala
      .Option(impl.phase2EncryptionAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase2EncryptionAlgorithmsListValue.wrap(item)
        }.toList
      )
    override val phase1IntegrityAlgorithms: Option[
      List[zio.aws.ec2.model.Phase1IntegrityAlgorithmsListValue.ReadOnly]
    ] = scala
      .Option(impl.phase1IntegrityAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase1IntegrityAlgorithmsListValue.wrap(item)
        }.toList
      )
    override val phase2IntegrityAlgorithms: Option[
      List[zio.aws.ec2.model.Phase2IntegrityAlgorithmsListValue.ReadOnly]
    ] = scala
      .Option(impl.phase2IntegrityAlgorithms())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase2IntegrityAlgorithmsListValue.wrap(item)
        }.toList
      )
    override val phase1DHGroupNumbers: Option[
      List[zio.aws.ec2.model.Phase1DHGroupNumbersListValue.ReadOnly]
    ] = scala
      .Option(impl.phase1DHGroupNumbers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase1DHGroupNumbersListValue.wrap(item)
        }.toList
      )
    override val phase2DHGroupNumbers: Option[
      List[zio.aws.ec2.model.Phase2DHGroupNumbersListValue.ReadOnly]
    ] = scala
      .Option(impl.phase2DHGroupNumbers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Phase2DHGroupNumbersListValue.wrap(item)
        }.toList
      )
    override val ikeVersions
        : Option[List[zio.aws.ec2.model.IKEVersionsListValue.ReadOnly]] = scala
      .Option(impl.ikeVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.IKEVersionsListValue.wrap(item)
        }.toList
      )
    override val startupAction: Option[String] =
      scala.Option(impl.startupAction()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TunnelOption
  ): zio.aws.ec2.model.TunnelOption.ReadOnly = new Wrapper(impl)
}
