package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayMulticastDomainAssociation(
    transitGatewayAttachmentId: Option[String] = None,
    resourceId: Option[String] = None,
    resourceType: Option[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = None,
    resourceOwnerId: Option[String] = None,
    subnet: Option[zio.aws.ec2.model.SubnetAssociation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociation = {
    import TransitGatewayMulticastDomainAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociation
      .builder()
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(resourceOwnerId.map(value => value: java.lang.String))(
        _.resourceOwnerId
      )
      .optionallyWith(subnet.map(value => value.buildAwsValue()))(_.subnet)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.ReadOnly =
    zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation
      .wrap(buildAwsValue())
}
object TransitGatewayMulticastDomainAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation =
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation(
        transitGatewayAttachmentId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        resourceOwnerId.map(value => value),
        subnet.map(value => value.asEditable)
      )
    def transitGatewayAttachmentId: Option[String]
    def resourceId: Option[String]
    def resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def resourceOwnerId: Option[String]
    def subnet: Option[zio.aws.ec2.model.SubnetAssociation.ReadOnly]
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceOwnerId", resourceOwnerId)
    def getSubnet
        : ZIO[Any, AwsError, zio.aws.ec2.model.SubnetAssociation.ReadOnly] =
      AwsError.unwrapOptionField("subnet", subnet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociation
  ) extends zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.ReadOnly {
    override val transitGatewayAttachmentId: Option[String] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value => value: String)
    override val resourceId: Option[String] =
      scala.Option(impl.resourceId()).map(value => value: String)
    override val resourceType
        : Option[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
      )
    override val resourceOwnerId: Option[String] =
      scala.Option(impl.resourceOwnerId()).map(value => value: String)
    override val subnet: Option[zio.aws.ec2.model.SubnetAssociation.ReadOnly] =
      scala
        .Option(impl.subnet())
        .map(value => zio.aws.ec2.model.SubnetAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayMulticastDomainAssociation
  ): zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.ReadOnly =
    new Wrapper(impl)
}
