package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait RouteTableAssociationStateCode {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode
}
object RouteTableAssociationStateCode {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode
  ): zio.aws.ec2.model.RouteTableAssociationStateCode = value match {
    case software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.ASSOCIATING =>
      val r = associating
      r
    case software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.ASSOCIATED =>
      val r = associated
      r
    case software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.DISASSOCIATING =>
      val r = disassociating
      r
    case software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.DISASSOCIATED =>
      val r = disassociated
      r
    case software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.RouteTableAssociationStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode =
      software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.UNKNOWN_TO_SDK_VERSION
  }
  case object associating
      extends zio.aws.ec2.model.RouteTableAssociationStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode =
      software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.ASSOCIATING
  }
  case object associated
      extends zio.aws.ec2.model.RouteTableAssociationStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode =
      software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.ASSOCIATED
  }
  case object disassociating
      extends zio.aws.ec2.model.RouteTableAssociationStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode =
      software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.DISASSOCIATING
  }
  case object disassociated
      extends zio.aws.ec2.model.RouteTableAssociationStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode =
      software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.DISASSOCIATED
  }
  case object failed extends zio.aws.ec2.model.RouteTableAssociationStateCode {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode =
      software.amazon.awssdk.services.ec2.model.RouteTableAssociationStateCode.FAILED
  }
}
