package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResponseLaunchTemplateData(
    kernelId: Option[String] = None,
    ebsOptimized: Option[Boolean] = None,
    iamInstanceProfile: Option[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecification
    ] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping]
    ] = None,
    networkInterfaces: Option[Iterable[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification
    ]] = None,
    imageId: Option[String] = None,
    instanceType: Option[zio.aws.ec2.model.InstanceType] = None,
    keyName: Option[String] = None,
    monitoring: Option[zio.aws.ec2.model.LaunchTemplatesMonitoring] = None,
    placement: Option[zio.aws.ec2.model.LaunchTemplatePlacement] = None,
    ramDiskId: Option[String] = None,
    disableApiTermination: Option[Boolean] = None,
    instanceInitiatedShutdownBehavior: Option[
      zio.aws.ec2.model.ShutdownBehavior
    ] = None,
    userData: Option[String] = None,
    tagSpecifications: Option[
      Iterable[zio.aws.ec2.model.LaunchTemplateTagSpecification]
    ] = None,
    elasticGpuSpecifications: Option[
      Iterable[zio.aws.ec2.model.ElasticGpuSpecificationResponse]
    ] = None,
    elasticInferenceAccelerators: Option[Iterable[
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse
    ]] = None,
    securityGroupIds: Option[Iterable[String]] = None,
    securityGroups: Option[Iterable[String]] = None,
    instanceMarketOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions
    ] = None,
    creditSpecification: Option[zio.aws.ec2.model.CreditSpecification] = None,
    cpuOptions: Option[zio.aws.ec2.model.LaunchTemplateCpuOptions] = None,
    capacityReservationSpecification: Option[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse
    ] = None,
    licenseSpecifications: Option[
      Iterable[zio.aws.ec2.model.LaunchTemplateLicenseConfiguration]
    ] = None,
    hibernationOptions: Option[
      zio.aws.ec2.model.LaunchTemplateHibernationOptions
    ] = None,
    metadataOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptions
    ] = None,
    enclaveOptions: Option[zio.aws.ec2.model.LaunchTemplateEnclaveOptions] =
      None,
    instanceRequirements: Option[zio.aws.ec2.model.InstanceRequirements] = None,
    privateDnsNameOptions: Option[
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData = {
    import ResponseLaunchTemplateData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData
      .builder()
      .optionallyWith(kernelId.map(value => value: java.lang.String))(
        _.kernelId
      )
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(keyName.map(value => value: java.lang.String))(_.keyName)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(ramDiskId.map(value => value: java.lang.String))(
        _.ramDiskId
      )
      .optionallyWith(
        disableApiTermination.map(value => value: java.lang.Boolean)
      )(_.disableApiTermination)
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.unwrap)
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(userData.map(value => value: java.lang.String))(
        _.userData
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(
        elasticGpuSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticGpuSpecifications)
      .optionallyWith(
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticInferenceAccelerators)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        instanceMarketOptions.map(value => value.buildAwsValue())
      )(_.instanceMarketOptions)
      .optionallyWith(creditSpecification.map(value => value.buildAwsValue()))(
        _.creditSpecification
      )
      .optionallyWith(cpuOptions.map(value => value.buildAwsValue()))(
        _.cpuOptions
      )
      .optionallyWith(
        capacityReservationSpecification.map(value => value.buildAwsValue())
      )(_.capacityReservationSpecification)
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(hibernationOptions.map(value => value.buildAwsValue()))(
        _.hibernationOptions
      )
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .optionallyWith(enclaveOptions.map(value => value.buildAwsValue()))(
        _.enclaveOptions
      )
      .optionallyWith(instanceRequirements.map(value => value.buildAwsValue()))(
        _.instanceRequirements
      )
      .optionallyWith(
        privateDnsNameOptions.map(value => value.buildAwsValue())
      )(_.privateDnsNameOptions)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly =
    zio.aws.ec2.model.ResponseLaunchTemplateData.wrap(buildAwsValue())
}
object ResponseLaunchTemplateData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResponseLaunchTemplateData =
      zio.aws.ec2.model.ResponseLaunchTemplateData(
        kernelId.map(value => value),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        imageId.map(value => value),
        instanceType.map(value => value),
        keyName.map(value => value),
        monitoring.map(value => value.asEditable),
        placement.map(value => value.asEditable),
        ramDiskId.map(value => value),
        disableApiTermination.map(value => value),
        instanceInitiatedShutdownBehavior.map(value => value),
        userData.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticGpuSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticInferenceAccelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        securityGroupIds.map(value => value),
        securityGroups.map(value => value),
        instanceMarketOptions.map(value => value.asEditable),
        creditSpecification.map(value => value.asEditable),
        cpuOptions.map(value => value.asEditable),
        capacityReservationSpecification.map(value => value.asEditable),
        licenseSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hibernationOptions.map(value => value.asEditable),
        metadataOptions.map(value => value.asEditable),
        enclaveOptions.map(value => value.asEditable),
        instanceRequirements.map(value => value.asEditable),
        privateDnsNameOptions.map(value => value.asEditable)
      )
    def kernelId: Option[String]
    def ebsOptimized: Option[Boolean]
    def iamInstanceProfile: Option[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecification.ReadOnly
    ]
    def blockDeviceMappings: Option[
      List[zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.ReadOnly]
    ]
    def networkInterfaces: Option[List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification.ReadOnly
    ]]
    def imageId: Option[String]
    def instanceType: Option[zio.aws.ec2.model.InstanceType]
    def keyName: Option[String]
    def monitoring: Option[zio.aws.ec2.model.LaunchTemplatesMonitoring.ReadOnly]
    def placement: Option[zio.aws.ec2.model.LaunchTemplatePlacement.ReadOnly]
    def ramDiskId: Option[String]
    def disableApiTermination: Option[Boolean]
    def instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.ShutdownBehavior]
    def userData: Option[String]
    def tagSpecifications: Option[
      List[zio.aws.ec2.model.LaunchTemplateTagSpecification.ReadOnly]
    ]
    def elasticGpuSpecifications: Option[
      List[zio.aws.ec2.model.ElasticGpuSpecificationResponse.ReadOnly]
    ]
    def elasticInferenceAccelerators: Option[List[
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse.ReadOnly
    ]]
    def securityGroupIds: Option[List[String]]
    def securityGroups: Option[List[String]]
    def instanceMarketOptions
        : Option[zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.ReadOnly]
    def creditSpecification
        : Option[zio.aws.ec2.model.CreditSpecification.ReadOnly]
    def cpuOptions: Option[zio.aws.ec2.model.LaunchTemplateCpuOptions.ReadOnly]
    def capacityReservationSpecification: Option[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse.ReadOnly
    ]
    def licenseSpecifications: Option[
      List[zio.aws.ec2.model.LaunchTemplateLicenseConfiguration.ReadOnly]
    ]
    def hibernationOptions
        : Option[zio.aws.ec2.model.LaunchTemplateHibernationOptions.ReadOnly]
    def metadataOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptions.ReadOnly
    ]
    def enclaveOptions
        : Option[zio.aws.ec2.model.LaunchTemplateEnclaveOptions.ReadOnly]
    def instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirements.ReadOnly]
    def privateDnsNameOptions
        : Option[zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.ReadOnly]
    def getKernelId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKeyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatesMonitoring.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
    def getPlacement: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatePlacement.ReadOnly
    ] = AwsError.unwrapOptionField("placement", placement)
    def getRamDiskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ramDiskId", ramDiskId)
    def getDisableApiTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("disableApiTermination", disableApiTermination)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.ShutdownBehavior] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getUserData: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userData", userData)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateTagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getElasticGpuSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ElasticGpuSpecificationResponse.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticGpuSpecifications",
      elasticGpuSpecifications
    )
    def getElasticInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "elasticInferenceAccelerators",
      elasticInferenceAccelerators
    )
    def getSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getInstanceMarketOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("instanceMarketOptions", instanceMarketOptions)
    def getCreditSpecification
        : ZIO[Any, AwsError, zio.aws.ec2.model.CreditSpecification.ReadOnly] =
      AwsError.unwrapOptionField("creditSpecification", creditSpecification)
    def getCpuOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateCpuOptions.ReadOnly
    ] = AwsError.unwrapOptionField("cpuOptions", cpuOptions)
    def getCapacityReservationSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationSpecification",
      capacityReservationSpecification
    )
    def getLicenseSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.LaunchTemplateLicenseConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("licenseSpecifications", licenseSpecifications)
    def getHibernationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateHibernationOptions.ReadOnly
    ] = AwsError.unwrapOptionField("hibernationOptions", hibernationOptions)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptions.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
    def getEnclaveOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateEnclaveOptions.ReadOnly
    ] = AwsError.unwrapOptionField("enclaveOptions", enclaveOptions)
    def getInstanceRequirements
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceRequirements.ReadOnly] =
      AwsError.unwrapOptionField("instanceRequirements", instanceRequirements)
    def getPrivateDnsNameOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("privateDnsNameOptions", privateDnsNameOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData
  ) extends zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly {
    override val kernelId: Option[String] =
      scala.Option(impl.kernelId()).map(value => value: String)
    override val ebsOptimized: Option[Boolean] =
      scala.Option(impl.ebsOptimized()).map(value => value: Boolean)
    override val iamInstanceProfile: Option[
      zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecification.ReadOnly
    ] = scala
      .Option(impl.iamInstanceProfile())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateIamInstanceProfileSpecification
          .wrap(value)
      )
    override val blockDeviceMappings: Option[
      List[zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.ReadOnly]
    ] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateBlockDeviceMapping.wrap(item)
        }.toList
      )
    override val networkInterfaces: Option[List[
      zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification.ReadOnly
    ]] = scala
      .Option(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification
            .wrap(item)
        }.toList
      )
    override val imageId: Option[String] =
      scala.Option(impl.imageId()).map(value => value: String)
    override val instanceType: Option[zio.aws.ec2.model.InstanceType] = scala
      .Option(impl.instanceType())
      .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val keyName: Option[String] =
      scala.Option(impl.keyName()).map(value => value: String)
    override val monitoring
        : Option[zio.aws.ec2.model.LaunchTemplatesMonitoring.ReadOnly] = scala
      .Option(impl.monitoring())
      .map(value => zio.aws.ec2.model.LaunchTemplatesMonitoring.wrap(value))
    override val placement
        : Option[zio.aws.ec2.model.LaunchTemplatePlacement.ReadOnly] = scala
      .Option(impl.placement())
      .map(value => zio.aws.ec2.model.LaunchTemplatePlacement.wrap(value))
    override val ramDiskId: Option[String] =
      scala.Option(impl.ramDiskId()).map(value => value: String)
    override val disableApiTermination: Option[Boolean] =
      scala.Option(impl.disableApiTermination()).map(value => value: Boolean)
    override val instanceInitiatedShutdownBehavior
        : Option[zio.aws.ec2.model.ShutdownBehavior] = scala
      .Option(impl.instanceInitiatedShutdownBehavior())
      .map(value => zio.aws.ec2.model.ShutdownBehavior.wrap(value))
    override val userData: Option[String] =
      scala.Option(impl.userData()).map(value => value: String)
    override val tagSpecifications: Option[
      List[zio.aws.ec2.model.LaunchTemplateTagSpecification.ReadOnly]
    ] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateTagSpecification.wrap(item)
        }.toList
      )
    override val elasticGpuSpecifications: Option[
      List[zio.aws.ec2.model.ElasticGpuSpecificationResponse.ReadOnly]
    ] = scala
      .Option(impl.elasticGpuSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ElasticGpuSpecificationResponse.wrap(item)
        }.toList
      )
    override val elasticInferenceAccelerators: Option[List[
      zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse.ReadOnly
    ]] = scala
      .Option(impl.elasticInferenceAccelerators())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse
            .wrap(item)
        }.toList
      )
    override val securityGroupIds: Option[List[String]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val securityGroups: Option[List[String]] = scala
      .Option(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val instanceMarketOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.ReadOnly
    ] = scala
      .Option(impl.instanceMarketOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMarketOptions.wrap(value)
      )
    override val creditSpecification
        : Option[zio.aws.ec2.model.CreditSpecification.ReadOnly] = scala
      .Option(impl.creditSpecification())
      .map(value => zio.aws.ec2.model.CreditSpecification.wrap(value))
    override val cpuOptions
        : Option[zio.aws.ec2.model.LaunchTemplateCpuOptions.ReadOnly] = scala
      .Option(impl.cpuOptions())
      .map(value => zio.aws.ec2.model.LaunchTemplateCpuOptions.wrap(value))
    override val capacityReservationSpecification: Option[
      zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse.ReadOnly
    ] = scala
      .Option(impl.capacityReservationSpecification())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse
          .wrap(value)
      )
    override val licenseSpecifications: Option[
      List[zio.aws.ec2.model.LaunchTemplateLicenseConfiguration.ReadOnly]
    ] = scala
      .Option(impl.licenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.LaunchTemplateLicenseConfiguration.wrap(item)
        }.toList
      )
    override val hibernationOptions
        : Option[zio.aws.ec2.model.LaunchTemplateHibernationOptions.ReadOnly] =
      scala
        .Option(impl.hibernationOptions())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplateHibernationOptions.wrap(value)
        )
    override val metadataOptions: Option[
      zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptions.ReadOnly
    ] = scala
      .Option(impl.metadataOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplateInstanceMetadataOptions.wrap(value)
      )
    override val enclaveOptions
        : Option[zio.aws.ec2.model.LaunchTemplateEnclaveOptions.ReadOnly] =
      scala
        .Option(impl.enclaveOptions())
        .map(value =>
          zio.aws.ec2.model.LaunchTemplateEnclaveOptions.wrap(value)
        )
    override val instanceRequirements
        : Option[zio.aws.ec2.model.InstanceRequirements.ReadOnly] = scala
      .Option(impl.instanceRequirements())
      .map(value => zio.aws.ec2.model.InstanceRequirements.wrap(value))
    override val privateDnsNameOptions: Option[
      zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.ReadOnly
    ] = scala
      .Option(impl.privateDnsNameOptions())
      .map(value =>
        zio.aws.ec2.model.LaunchTemplatePrivateDnsNameOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData
  ): zio.aws.ec2.model.ResponseLaunchTemplateData.ReadOnly = new Wrapper(impl)
}
