package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait NetworkInterfaceAttribute {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute
}
object NetworkInterfaceAttribute {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute
  ): zio.aws.ec2.model.NetworkInterfaceAttribute = value match {
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute.DESCRIPTION =>
      val r = description
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute.GROUP_SET =>
      val r = groupSet
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute.SOURCE_DEST_CHECK =>
      val r = sourceDestCheck
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute.ATTACHMENT =>
      val r = attachment
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.NetworkInterfaceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute.UNKNOWN_TO_SDK_VERSION
  }
  case object description extends zio.aws.ec2.model.NetworkInterfaceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute.DESCRIPTION
  }
  case object groupSet extends zio.aws.ec2.model.NetworkInterfaceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute.GROUP_SET
  }
  case object sourceDestCheck
      extends zio.aws.ec2.model.NetworkInterfaceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute.SOURCE_DEST_CHECK
  }
  case object attachment extends zio.aws.ec2.model.NetworkInterfaceAttribute {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttribute.ATTACHMENT
  }
}
