package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpnConnectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyVpnTunnelOptionsRequest(
    vpnConnectionId: VpnConnectionId,
    vpnTunnelOutsideIpAddress: String,
    tunnelOptions: zio.aws.ec2.model.ModifyVpnTunnelOptionsSpecification
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsRequest = {
    import ModifyVpnTunnelOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsRequest
      .builder()
      .vpnConnectionId(
        VpnConnectionId.unwrap(vpnConnectionId): java.lang.String
      )
      .vpnTunnelOutsideIpAddress(vpnTunnelOutsideIpAddress: java.lang.String)
      .tunnelOptions(tunnelOptions.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpnTunnelOptionsRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpnTunnelOptionsRequest.wrap(buildAwsValue())
}
object ModifyVpnTunnelOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnTunnelOptionsRequest =
      zio.aws.ec2.model.ModifyVpnTunnelOptionsRequest(
        vpnConnectionId,
        vpnTunnelOutsideIpAddress,
        tunnelOptions.asEditable
      )
    def vpnConnectionId: VpnConnectionId
    def vpnTunnelOutsideIpAddress: String
    def tunnelOptions
        : zio.aws.ec2.model.ModifyVpnTunnelOptionsSpecification.ReadOnly
    def getVpnConnectionId: ZIO[Any, Nothing, VpnConnectionId] =
      ZIO.succeed(vpnConnectionId)
    def getVpnTunnelOutsideIpAddress: ZIO[Any, Nothing, String] =
      ZIO.succeed(vpnTunnelOutsideIpAddress)
    def getTunnelOptions: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.ModifyVpnTunnelOptionsSpecification.ReadOnly
    ] = ZIO.succeed(tunnelOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsRequest
  ) extends zio.aws.ec2.model.ModifyVpnTunnelOptionsRequest.ReadOnly {
    override val vpnConnectionId: VpnConnectionId =
      zio.aws.ec2.model.primitives.VpnConnectionId(impl.vpnConnectionId())
    override val vpnTunnelOutsideIpAddress: String =
      impl.vpnTunnelOutsideIpAddress(): String
    override val tunnelOptions
        : zio.aws.ec2.model.ModifyVpnTunnelOptionsSpecification.ReadOnly =
      zio.aws.ec2.model.ModifyVpnTunnelOptionsSpecification
        .wrap(impl.tunnelOptions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnTunnelOptionsRequest
  ): zio.aws.ec2.model.ModifyVpnTunnelOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
