package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  ResourceArn,
  LocalGatewayId,
  LocalGatewayVirtualInterfaceGroupId,
  LocalGatewayRouteTableVirtualInterfaceGroupAssociationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LocalGatewayRouteTableVirtualInterfaceGroupAssociation(
    localGatewayRouteTableVirtualInterfaceGroupAssociationId: Option[
      LocalGatewayRouteTableVirtualInterfaceGroupAssociationId
    ] = None,
    localGatewayVirtualInterfaceGroupId: Option[
      LocalGatewayVirtualInterfaceGroupId
    ] = None,
    localGatewayId: Option[String] = None,
    localGatewayRouteTableId: Option[LocalGatewayId] = None,
    localGatewayRouteTableArn: Option[ResourceArn] = None,
    ownerId: Option[String] = None,
    state: Option[String] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation = {
    import LocalGatewayRouteTableVirtualInterfaceGroupAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
      .builder()
      .optionallyWith(
        localGatewayRouteTableVirtualInterfaceGroupAssociationId.map(value =>
          LocalGatewayRouteTableVirtualInterfaceGroupAssociationId.unwrap(
            value
          ): java.lang.String
        )
      )(_.localGatewayRouteTableVirtualInterfaceGroupAssociationId)
      .optionallyWith(
        localGatewayVirtualInterfaceGroupId.map(value =>
          LocalGatewayVirtualInterfaceGroupId.unwrap(value): java.lang.String
        )
      )(_.localGatewayVirtualInterfaceGroupId)
      .optionallyWith(localGatewayId.map(value => value: java.lang.String))(
        _.localGatewayId
      )
      .optionallyWith(
        localGatewayRouteTableId.map(value =>
          LocalGatewayId.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableId)
      .optionallyWith(
        localGatewayRouteTableArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.localGatewayRouteTableArn)
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly =
    zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
      .wrap(buildAwsValue())
}
object LocalGatewayRouteTableVirtualInterfaceGroupAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation =
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation(
        localGatewayRouteTableVirtualInterfaceGroupAssociationId.map(value =>
          value
        ),
        localGatewayVirtualInterfaceGroupId.map(value => value),
        localGatewayId.map(value => value),
        localGatewayRouteTableId.map(value => value),
        localGatewayRouteTableArn.map(value => value),
        ownerId.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def localGatewayRouteTableVirtualInterfaceGroupAssociationId
        : Option[LocalGatewayRouteTableVirtualInterfaceGroupAssociationId]
    def localGatewayVirtualInterfaceGroupId
        : Option[LocalGatewayVirtualInterfaceGroupId]
    def localGatewayId: Option[String]
    def localGatewayRouteTableId: Option[LocalGatewayId]
    def localGatewayRouteTableArn: Option[ResourceArn]
    def ownerId: Option[String]
    def state: Option[String]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getLocalGatewayRouteTableVirtualInterfaceGroupAssociationId: ZIO[
      Any,
      AwsError,
      LocalGatewayRouteTableVirtualInterfaceGroupAssociationId
    ] = AwsError.unwrapOptionField(
      "localGatewayRouteTableVirtualInterfaceGroupAssociationId",
      localGatewayRouteTableVirtualInterfaceGroupAssociationId
    )
    def getLocalGatewayVirtualInterfaceGroupId
        : ZIO[Any, AwsError, LocalGatewayVirtualInterfaceGroupId] =
      AwsError.unwrapOptionField(
        "localGatewayVirtualInterfaceGroupId",
        localGatewayVirtualInterfaceGroupId
      )
    def getLocalGatewayId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("localGatewayId", localGatewayId)
    def getLocalGatewayRouteTableId: ZIO[Any, AwsError, LocalGatewayId] =
      AwsError.unwrapOptionField(
        "localGatewayRouteTableId",
        localGatewayRouteTableId
      )
    def getLocalGatewayRouteTableArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("localGatewayRouteTableArn", localGatewayRouteTableArn)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
  ) extends zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly {
    override val localGatewayRouteTableVirtualInterfaceGroupAssociationId
        : Option[LocalGatewayRouteTableVirtualInterfaceGroupAssociationId] =
      scala
        .Option(impl.localGatewayRouteTableVirtualInterfaceGroupAssociationId())
        .map(value =>
          zio.aws.ec2.model.primitives
            .LocalGatewayRouteTableVirtualInterfaceGroupAssociationId(value)
        )
    override val localGatewayVirtualInterfaceGroupId
        : Option[LocalGatewayVirtualInterfaceGroupId] = scala
      .Option(impl.localGatewayVirtualInterfaceGroupId())
      .map(value =>
        zio.aws.ec2.model.primitives.LocalGatewayVirtualInterfaceGroupId(value)
      )
    override val localGatewayId: Option[String] =
      scala.Option(impl.localGatewayId()).map(value => value: String)
    override val localGatewayRouteTableId: Option[LocalGatewayId] = scala
      .Option(impl.localGatewayRouteTableId())
      .map(value => zio.aws.ec2.model.primitives.LocalGatewayId(value))
    override val localGatewayRouteTableArn: Option[ResourceArn] = scala
      .Option(impl.localGatewayRouteTableArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val ownerId: Option[String] =
      scala.Option(impl.ownerId()).map(value => value: String)
    override val state: Option[String] =
      scala.Option(impl.state()).map(value => value: String)
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
  ): zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly =
    new Wrapper(impl)
}
