package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateAndOverridesResponse(
    launchTemplateSpecification: Option[
      zio.aws.ec2.model.FleetLaunchTemplateSpecification
    ] = None,
    overrides: Option[zio.aws.ec2.model.FleetLaunchTemplateOverrides] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateAndOverridesResponse = {
    import LaunchTemplateAndOverridesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateAndOverridesResponse
      .builder()
      .optionallyWith(
        launchTemplateSpecification.map(value => value.buildAwsValue())
      )(_.launchTemplateSpecification)
      .optionallyWith(overrides.map(value => value.buildAwsValue()))(
        _.overrides
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.wrap(buildAwsValue())
}
object LaunchTemplateAndOverridesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateAndOverridesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateAndOverridesResponse =
      zio.aws.ec2.model.LaunchTemplateAndOverridesResponse(
        launchTemplateSpecification.map(value => value.asEditable),
        overrides.map(value => value.asEditable)
      )
    def launchTemplateSpecification
        : Option[zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly]
    def overrides
        : Option[zio.aws.ec2.model.FleetLaunchTemplateOverrides.ReadOnly]
    def getLaunchTemplateSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "launchTemplateSpecification",
      launchTemplateSpecification
    )
    def getOverrides: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetLaunchTemplateOverrides.ReadOnly
    ] = AwsError.unwrapOptionField("overrides", overrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateAndOverridesResponse
  ) extends zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly {
    override val launchTemplateSpecification
        : Option[zio.aws.ec2.model.FleetLaunchTemplateSpecification.ReadOnly] =
      scala
        .Option(impl.launchTemplateSpecification())
        .map(value =>
          zio.aws.ec2.model.FleetLaunchTemplateSpecification.wrap(value)
        )
    override val overrides
        : Option[zio.aws.ec2.model.FleetLaunchTemplateOverrides.ReadOnly] =
      scala
        .Option(impl.overrides())
        .map(value =>
          zio.aws.ec2.model.FleetLaunchTemplateOverrides.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateAndOverridesResponse
  ): zio.aws.ec2.model.LaunchTemplateAndOverridesResponse.ReadOnly =
    new Wrapper(impl)
}
