package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KeyPairInfo(
    keyPairId: Option[String] = None,
    keyFingerprint: Option[String] = None,
    keyName: Option[String] = None,
    keyType: Option[zio.aws.ec2.model.KeyType] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.KeyPairInfo = {
    import KeyPairInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.KeyPairInfo
      .builder()
      .optionallyWith(keyPairId.map(value => value: java.lang.String))(
        _.keyPairId
      )
      .optionallyWith(keyFingerprint.map(value => value: java.lang.String))(
        _.keyFingerprint
      )
      .optionallyWith(keyName.map(value => value: java.lang.String))(_.keyName)
      .optionallyWith(keyType.map(value => value.unwrap))(_.keyType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.KeyPairInfo.ReadOnly =
    zio.aws.ec2.model.KeyPairInfo.wrap(buildAwsValue())
}
object KeyPairInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.KeyPairInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.KeyPairInfo =
      zio.aws.ec2.model.KeyPairInfo(
        keyPairId.map(value => value),
        keyFingerprint.map(value => value),
        keyName.map(value => value),
        keyType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def keyPairId: Option[String]
    def keyFingerprint: Option[String]
    def keyName: Option[String]
    def keyType: Option[zio.aws.ec2.model.KeyType]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getKeyPairId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyPairId", keyPairId)
    def getKeyFingerprint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyFingerprint", keyFingerprint)
    def getKeyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getKeyType: ZIO[Any, AwsError, zio.aws.ec2.model.KeyType] =
      AwsError.unwrapOptionField("keyType", keyType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.KeyPairInfo
  ) extends zio.aws.ec2.model.KeyPairInfo.ReadOnly {
    override val keyPairId: Option[String] =
      scala.Option(impl.keyPairId()).map(value => value: String)
    override val keyFingerprint: Option[String] =
      scala.Option(impl.keyFingerprint()).map(value => value: String)
    override val keyName: Option[String] =
      scala.Option(impl.keyName()).map(value => value: String)
    override val keyType: Option[zio.aws.ec2.model.KeyType] = scala
      .Option(impl.keyType())
      .map(value => zio.aws.ec2.model.KeyType.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.KeyPairInfo
  ): zio.aws.ec2.model.KeyPairInfo.ReadOnly = new Wrapper(impl)
}
