package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InternetGatewayAttachment(
    state: Option[zio.aws.ec2.model.AttachmentStatus] = None,
    vpcId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment = {
    import InternetGatewayAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly =
    zio.aws.ec2.model.InternetGatewayAttachment.wrap(buildAwsValue())
}
object InternetGatewayAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InternetGatewayAttachment =
      zio.aws.ec2.model.InternetGatewayAttachment(
        state.map(value => value),
        vpcId.map(value => value)
      )
    def state: Option[zio.aws.ec2.model.AttachmentStatus]
    def vpcId: Option[String]
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.AttachmentStatus] =
      AwsError.unwrapOptionField("state", state)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment
  ) extends zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly {
    override val state: Option[zio.aws.ec2.model.AttachmentStatus] = scala
      .Option(impl.state())
      .map(value => zio.aws.ec2.model.AttachmentStatus.wrap(value))
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment
  ): zio.aws.ec2.model.InternetGatewayAttachment.ReadOnly = new Wrapper(impl)
}
