package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceStatus(
    availabilityZone: Option[String] = None,
    outpostArn: Option[String] = None,
    events: Option[Iterable[zio.aws.ec2.model.InstanceStatusEvent]] = None,
    instanceId: Option[String] = None,
    instanceState: Option[zio.aws.ec2.model.InstanceState] = None,
    instanceStatus: Option[zio.aws.ec2.model.InstanceStatusSummary] = None,
    systemStatus: Option[zio.aws.ec2.model.InstanceStatusSummary] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.InstanceStatus = {
    import InstanceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.InstanceStatus
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(instanceState.map(value => value.buildAwsValue()))(
        _.instanceState
      )
      .optionallyWith(instanceStatus.map(value => value.buildAwsValue()))(
        _.instanceStatus
      )
      .optionallyWith(systemStatus.map(value => value.buildAwsValue()))(
        _.systemStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.InstanceStatus.ReadOnly =
    zio.aws.ec2.model.InstanceStatus.wrap(buildAwsValue())
}
object InstanceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.InstanceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.InstanceStatus =
      zio.aws.ec2.model.InstanceStatus(
        availabilityZone.map(value => value),
        outpostArn.map(value => value),
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceId.map(value => value),
        instanceState.map(value => value.asEditable),
        instanceStatus.map(value => value.asEditable),
        systemStatus.map(value => value.asEditable)
      )
    def availabilityZone: Option[String]
    def outpostArn: Option[String]
    def events: Option[List[zio.aws.ec2.model.InstanceStatusEvent.ReadOnly]]
    def instanceId: Option[String]
    def instanceState: Option[zio.aws.ec2.model.InstanceState.ReadOnly]
    def instanceStatus: Option[zio.aws.ec2.model.InstanceStatusSummary.ReadOnly]
    def systemStatus: Option[zio.aws.ec2.model.InstanceStatusSummary.ReadOnly]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceStatusEvent.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceState
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceState.ReadOnly] =
      AwsError.unwrapOptionField("instanceState", instanceState)
    def getInstanceStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceStatusSummary.ReadOnly] =
      AwsError.unwrapOptionField("instanceStatus", instanceStatus)
    def getSystemStatus
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceStatusSummary.ReadOnly] =
      AwsError.unwrapOptionField("systemStatus", systemStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStatus
  ) extends zio.aws.ec2.model.InstanceStatus.ReadOnly {
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val outpostArn: Option[String] =
      scala.Option(impl.outpostArn()).map(value => value: String)
    override val events
        : Option[List[zio.aws.ec2.model.InstanceStatusEvent.ReadOnly]] = scala
      .Option(impl.events())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceStatusEvent.wrap(item)
        }.toList
      )
    override val instanceId: Option[String] =
      scala.Option(impl.instanceId()).map(value => value: String)
    override val instanceState
        : Option[zio.aws.ec2.model.InstanceState.ReadOnly] = scala
      .Option(impl.instanceState())
      .map(value => zio.aws.ec2.model.InstanceState.wrap(value))
    override val instanceStatus
        : Option[zio.aws.ec2.model.InstanceStatusSummary.ReadOnly] = scala
      .Option(impl.instanceStatus())
      .map(value => zio.aws.ec2.model.InstanceStatusSummary.wrap(value))
    override val systemStatus
        : Option[zio.aws.ec2.model.InstanceStatusSummary.ReadOnly] = scala
      .Option(impl.systemStatus())
      .map(value => zio.aws.ec2.model.InstanceStatusSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.InstanceStatus
  ): zio.aws.ec2.model.InstanceStatus.ReadOnly = new Wrapper(impl)
}
