package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportSnapshotTask(
    description: Option[String] = None,
    importTaskId: Option[String] = None,
    snapshotTaskDetail: Option[zio.aws.ec2.model.SnapshotTaskDetail] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportSnapshotTask = {
    import ImportSnapshotTask.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportSnapshotTask
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(importTaskId.map(value => value: java.lang.String))(
        _.importTaskId
      )
      .optionallyWith(snapshotTaskDetail.map(value => value.buildAwsValue()))(
        _.snapshotTaskDetail
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportSnapshotTask.ReadOnly =
    zio.aws.ec2.model.ImportSnapshotTask.wrap(buildAwsValue())
}
object ImportSnapshotTask {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportSnapshotTask
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportSnapshotTask =
      zio.aws.ec2.model.ImportSnapshotTask(
        description.map(value => value),
        importTaskId.map(value => value),
        snapshotTaskDetail.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Option[String]
    def importTaskId: Option[String]
    def snapshotTaskDetail
        : Option[zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getImportTaskId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("importTaskId", importTaskId)
    def getSnapshotTaskDetail
        : ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly] =
      AwsError.unwrapOptionField("snapshotTaskDetail", snapshotTaskDetail)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportSnapshotTask
  ) extends zio.aws.ec2.model.ImportSnapshotTask.ReadOnly {
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val importTaskId: Option[String] =
      scala.Option(impl.importTaskId()).map(value => value: String)
    override val snapshotTaskDetail
        : Option[zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly] = scala
      .Option(impl.snapshotTaskDetail())
      .map(value => zio.aws.ec2.model.SnapshotTaskDetail.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportSnapshotTask
  ): zio.aws.ec2.model.ImportSnapshotTask.ReadOnly = new Wrapper(impl)
}
