package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.KmsKeyId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportImageRequest(
    architecture: Option[String] = None,
    clientData: Option[zio.aws.ec2.model.ClientData] = None,
    clientToken: Option[String] = None,
    description: Option[String] = None,
    diskContainers: Option[Iterable[zio.aws.ec2.model.ImageDiskContainer]] =
      None,
    encrypted: Option[Boolean] = None,
    hypervisor: Option[String] = None,
    kmsKeyId: Option[KmsKeyId] = None,
    licenseType: Option[String] = None,
    platform: Option[String] = None,
    roleName: Option[String] = None,
    licenseSpecifications: Option[
      Iterable[zio.aws.ec2.model.ImportImageLicenseConfigurationRequest]
    ] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    usageOperation: Option[String] = None,
    bootMode: Option[zio.aws.ec2.model.BootModeValues] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ImportImageRequest = {
    import ImportImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ImportImageRequest
      .builder()
      .optionallyWith(architecture.map(value => value: java.lang.String))(
        _.architecture
      )
      .optionallyWith(clientData.map(value => value.buildAwsValue()))(
        _.clientData
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        diskContainers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.diskContainers)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(hypervisor.map(value => value: java.lang.String))(
        _.hypervisor
      )
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(licenseType.map(value => value: java.lang.String))(
        _.licenseType
      )
      .optionallyWith(platform.map(value => value: java.lang.String))(
        _.platform
      )
      .optionallyWith(roleName.map(value => value: java.lang.String))(
        _.roleName
      )
      .optionallyWith(
        licenseSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.licenseSpecifications)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(usageOperation.map(value => value: java.lang.String))(
        _.usageOperation
      )
      .optionallyWith(bootMode.map(value => value.unwrap))(_.bootMode)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ImportImageRequest.ReadOnly =
    zio.aws.ec2.model.ImportImageRequest.wrap(buildAwsValue())
}
object ImportImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ImportImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ImportImageRequest =
      zio.aws.ec2.model.ImportImageRequest(
        architecture.map(value => value),
        clientData.map(value => value.asEditable),
        clientToken.map(value => value),
        description.map(value => value),
        diskContainers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encrypted.map(value => value),
        hypervisor.map(value => value),
        kmsKeyId.map(value => value),
        licenseType.map(value => value),
        platform.map(value => value),
        roleName.map(value => value),
        licenseSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        usageOperation.map(value => value),
        bootMode.map(value => value)
      )
    def architecture: Option[String]
    def clientData: Option[zio.aws.ec2.model.ClientData.ReadOnly]
    def clientToken: Option[String]
    def description: Option[String]
    def diskContainers
        : Option[List[zio.aws.ec2.model.ImageDiskContainer.ReadOnly]]
    def encrypted: Option[Boolean]
    def hypervisor: Option[String]
    def kmsKeyId: Option[KmsKeyId]
    def licenseType: Option[String]
    def platform: Option[String]
    def roleName: Option[String]
    def licenseSpecifications: Option[
      List[zio.aws.ec2.model.ImportImageLicenseConfigurationRequest.ReadOnly]
    ]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def usageOperation: Option[String]
    def bootMode: Option[zio.aws.ec2.model.BootModeValues]
    def getArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("architecture", architecture)
    def getClientData
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientData.ReadOnly] =
      AwsError.unwrapOptionField("clientData", clientData)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDiskContainers: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ImageDiskContainer.ReadOnly
    ]] = AwsError.unwrapOptionField("diskContainers", diskContainers)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getHypervisor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hypervisor", hypervisor)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLicenseType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getPlatform: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platform", platform)
    def getRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getLicenseSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ImportImageLicenseConfigurationRequest.ReadOnly
    ]] =
      AwsError.unwrapOptionField("licenseSpecifications", licenseSpecifications)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getUsageOperation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("usageOperation", usageOperation)
    def getBootMode: ZIO[Any, AwsError, zio.aws.ec2.model.BootModeValues] =
      AwsError.unwrapOptionField("bootMode", bootMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageRequest
  ) extends zio.aws.ec2.model.ImportImageRequest.ReadOnly {
    override val architecture: Option[String] =
      scala.Option(impl.architecture()).map(value => value: String)
    override val clientData: Option[zio.aws.ec2.model.ClientData.ReadOnly] =
      scala
        .Option(impl.clientData())
        .map(value => zio.aws.ec2.model.ClientData.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val diskContainers
        : Option[List[zio.aws.ec2.model.ImageDiskContainer.ReadOnly]] = scala
      .Option(impl.diskContainers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ImageDiskContainer.wrap(item)
        }.toList
      )
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val hypervisor: Option[String] =
      scala.Option(impl.hypervisor()).map(value => value: String)
    override val kmsKeyId: Option[KmsKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.ec2.model.primitives.KmsKeyId(value))
    override val licenseType: Option[String] =
      scala.Option(impl.licenseType()).map(value => value: String)
    override val platform: Option[String] =
      scala.Option(impl.platform()).map(value => value: String)
    override val roleName: Option[String] =
      scala.Option(impl.roleName()).map(value => value: String)
    override val licenseSpecifications: Option[
      List[zio.aws.ec2.model.ImportImageLicenseConfigurationRequest.ReadOnly]
    ] = scala
      .Option(impl.licenseSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ImportImageLicenseConfigurationRequest.wrap(item)
        }.toList
      )
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val usageOperation: Option[String] =
      scala.Option(impl.usageOperation()).map(value => value: String)
    override val bootMode: Option[zio.aws.ec2.model.BootModeValues] = scala
      .Option(impl.bootMode())
      .map(value => zio.aws.ec2.model.BootModeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ImportImageRequest
  ): zio.aws.ec2.model.ImportImageRequest.ReadOnly = new Wrapper(impl)
}
