package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInstanceTypesFromInstanceRequirementsResponse(
    instanceTypes: Option[
      Iterable[zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse = {
    import GetInstanceTypesFromInstanceRequirementsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse
      .builder()
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse.ReadOnly =
    zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse
      .wrap(buildAwsValue())
}
object GetInstanceTypesFromInstanceRequirementsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse =
      zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse(
        instanceTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def instanceTypes: Option[
      List[zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.ReadOnly]
    ]
    def nextToken: Option[String]
    def getInstanceTypes: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse
  ) extends zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse.ReadOnly {
    override val instanceTypes: Option[
      List[zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.ReadOnly]
    ] = scala
      .Option(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse
  ): zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse.ReadOnly =
    new Wrapper(impl)
}
