package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableFastSnapshotRestoresRequest(
    availabilityZones: Iterable[String],
    sourceSnapshotIds: Iterable[SnapshotId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest = {
    import EnableFastSnapshotRestoresRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest
      .builder()
      .availabilityZones(availabilityZones.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .sourceSnapshotIds(sourceSnapshotIds.map { item =>
        SnapshotId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableFastSnapshotRestoresRequest.ReadOnly =
    zio.aws.ec2.model.EnableFastSnapshotRestoresRequest.wrap(buildAwsValue())
}
object EnableFastSnapshotRestoresRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableFastSnapshotRestoresRequest =
      zio.aws.ec2.model
        .EnableFastSnapshotRestoresRequest(availabilityZones, sourceSnapshotIds)
    def availabilityZones: List[String]
    def sourceSnapshotIds: List[SnapshotId]
    def getAvailabilityZones: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(availabilityZones)
    def getSourceSnapshotIds: ZIO[Any, Nothing, List[SnapshotId]] =
      ZIO.succeed(sourceSnapshotIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest
  ) extends zio.aws.ec2.model.EnableFastSnapshotRestoresRequest.ReadOnly {
    override val availabilityZones: List[String] = impl
      .availabilityZones()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val sourceSnapshotIds: List[SnapshotId] = impl
      .sourceSnapshotIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.SnapshotId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableFastSnapshotRestoresRequest
  ): zio.aws.ec2.model.EnableFastSnapshotRestoresRequest.ReadOnly = new Wrapper(
    impl
  )
}
