package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribePrincipalIdFormatResponse(
    principals: Option[Iterable[zio.aws.ec2.model.PrincipalIdFormat]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse = {
    import DescribePrincipalIdFormatResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse
      .builder()
      .optionallyWith(
        principals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.principals)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePrincipalIdFormatResponse.ReadOnly =
    zio.aws.ec2.model.DescribePrincipalIdFormatResponse.wrap(buildAwsValue())
}
object DescribePrincipalIdFormatResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePrincipalIdFormatResponse =
      zio.aws.ec2.model.DescribePrincipalIdFormatResponse(
        principals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def principals: Option[List[zio.aws.ec2.model.PrincipalIdFormat.ReadOnly]]
    def nextToken: Option[String]
    def getPrincipals: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.PrincipalIdFormat.ReadOnly
    ]] = AwsError.unwrapOptionField("principals", principals)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse
  ) extends zio.aws.ec2.model.DescribePrincipalIdFormatResponse.ReadOnly {
    override val principals
        : Option[List[zio.aws.ec2.model.PrincipalIdFormat.ReadOnly]] = scala
      .Option(impl.principals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.PrincipalIdFormat.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatResponse
  ): zio.aws.ec2.model.DescribePrincipalIdFormatResponse.ReadOnly = new Wrapper(
    impl
  )
}
