package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, HostReservationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHostReservationsRequest(
    filter: Option[Iterable[zio.aws.ec2.model.Filter]] = None,
    hostReservationIdSet: Option[Iterable[HostReservationId]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest = {
    import DescribeHostReservationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest
      .builder()
      .optionallyWith(
        filter.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filter)
      .optionallyWith(
        hostReservationIdSet.map(value =>
          value.map { item =>
            HostReservationId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.hostReservationIdSet)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeHostReservationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeHostReservationsRequest.wrap(buildAwsValue())
}
object DescribeHostReservationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeHostReservationsRequest =
      zio.aws.ec2.model.DescribeHostReservationsRequest(
        filter.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hostReservationIdSet.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filter: Option[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def hostReservationIdSet: Option[List[HostReservationId]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getFilter: ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filter", filter)
    def getHostReservationIdSet: ZIO[Any, AwsError, List[HostReservationId]] =
      AwsError.unwrapOptionField("hostReservationIdSet", hostReservationIdSet)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest
  ) extends zio.aws.ec2.model.DescribeHostReservationsRequest.ReadOnly {
    override val filter: Option[List[zio.aws.ec2.model.Filter.ReadOnly]] = scala
      .Option(impl.filter())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Filter.wrap(item)
        }.toList
      )
    override val hostReservationIdSet: Option[List[HostReservationId]] = scala
      .Option(impl.hostReservationIdSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.HostReservationId(item)
        }.toList
      )
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest
  ): zio.aws.ec2.model.DescribeHostReservationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
