package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DefaultRouteTableAssociationValue {
  def unwrap: software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue
}
object DefaultRouteTableAssociationValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue
  ): zio.aws.ec2.model.DefaultRouteTableAssociationValue = value match {
    case software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.DefaultRouteTableAssociationValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue =
      software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable
      extends zio.aws.ec2.model.DefaultRouteTableAssociationValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue =
      software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue.ENABLE
  }
  case object disable
      extends zio.aws.ec2.model.DefaultRouteTableAssociationValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue =
      software.amazon.awssdk.services.ec2.model.DefaultRouteTableAssociationValue.DISABLE
  }
}
