package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateTrafficMirrorTargetResponse(
    trafficMirrorTarget: Option[zio.aws.ec2.model.TrafficMirrorTarget] = None,
    clientToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse = {
    import CreateTrafficMirrorTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse
      .builder()
      .optionallyWith(trafficMirrorTarget.map(value => value.buildAwsValue()))(
        _.trafficMirrorTarget
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.ReadOnly =
    zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.wrap(buildAwsValue())
}
object CreateTrafficMirrorTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTrafficMirrorTargetResponse =
      zio.aws.ec2.model.CreateTrafficMirrorTargetResponse(
        trafficMirrorTarget.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def trafficMirrorTarget
        : Option[zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly]
    def clientToken: Option[String]
    def getTrafficMirrorTarget
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly] =
      AwsError.unwrapOptionField("trafficMirrorTarget", trafficMirrorTarget)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse
  ) extends zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.ReadOnly {
    override val trafficMirrorTarget
        : Option[zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly] = scala
      .Option(impl.trafficMirrorTarget())
      .map(value => zio.aws.ec2.model.TrafficMirrorTarget.wrap(value))
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse
  ): zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.ReadOnly = new Wrapper(
    impl
  )
}
