package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateRestoreImageTaskResponse(
    imageId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskResponse = {
    import CreateRestoreImageTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskResponse
      .builder()
      .optionallyWith(imageId.map(value => value: java.lang.String))(_.imageId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateRestoreImageTaskResponse.ReadOnly =
    zio.aws.ec2.model.CreateRestoreImageTaskResponse.wrap(buildAwsValue())
}
object CreateRestoreImageTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateRestoreImageTaskResponse =
      zio.aws.ec2.model
        .CreateRestoreImageTaskResponse(imageId.map(value => value))
    def imageId: Option[String]
    def getImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("imageId", imageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskResponse
  ) extends zio.aws.ec2.model.CreateRestoreImageTaskResponse.ReadOnly {
    override val imageId: Option[String] =
      scala.Option(impl.imageId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateRestoreImageTaskResponse
  ): zio.aws.ec2.model.CreateRestoreImageTaskResponse.ReadOnly = new Wrapper(
    impl
  )
}
