package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreatePlacementGroupRequest(
    groupName: Option[String] = None,
    strategy: Option[zio.aws.ec2.model.PlacementStrategy] = None,
    partitionCount: Option[Integer] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest = {
    import CreatePlacementGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(strategy.map(value => value.unwrap))(_.strategy)
      .optionallyWith(partitionCount.map(value => value: java.lang.Integer))(
        _.partitionCount
      )
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreatePlacementGroupRequest.ReadOnly =
    zio.aws.ec2.model.CreatePlacementGroupRequest.wrap(buildAwsValue())
}
object CreatePlacementGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreatePlacementGroupRequest =
      zio.aws.ec2.model.CreatePlacementGroupRequest(
        groupName.map(value => value),
        strategy.map(value => value),
        partitionCount.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def groupName: Option[String]
    def strategy: Option[zio.aws.ec2.model.PlacementStrategy]
    def partitionCount: Option[Integer]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getStrategy: ZIO[Any, AwsError, zio.aws.ec2.model.PlacementStrategy] =
      AwsError.unwrapOptionField("strategy", strategy)
    def getPartitionCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("partitionCount", partitionCount)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest
  ) extends zio.aws.ec2.model.CreatePlacementGroupRequest.ReadOnly {
    override val groupName: Option[String] =
      scala.Option(impl.groupName()).map(value => value: String)
    override val strategy: Option[zio.aws.ec2.model.PlacementStrategy] = scala
      .Option(impl.strategy())
      .map(value => zio.aws.ec2.model.PlacementStrategy.wrap(value))
    override val partitionCount: Option[Integer] =
      scala.Option(impl.partitionCount()).map(value => value: Integer)
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreatePlacementGroupRequest
  ): zio.aws.ec2.model.CreatePlacementGroupRequest.ReadOnly = new Wrapper(impl)
}
