package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SubnetId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateSubnetCidrBlockRequest(
    ipv6CidrBlock: String,
    subnetId: SubnetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest = {
    import AssociateSubnetCidrBlockRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest
      .builder()
      .ipv6CidrBlock(ipv6CidrBlock: java.lang.String)
      .subnetId(SubnetId.unwrap(subnetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateSubnetCidrBlockRequest.ReadOnly =
    zio.aws.ec2.model.AssociateSubnetCidrBlockRequest.wrap(buildAwsValue())
}
object AssociateSubnetCidrBlockRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateSubnetCidrBlockRequest =
      zio.aws.ec2.model.AssociateSubnetCidrBlockRequest(ipv6CidrBlock, subnetId)
    def ipv6CidrBlock: String
    def subnetId: SubnetId
    def getIpv6CidrBlock: ZIO[Any, Nothing, String] = ZIO.succeed(ipv6CidrBlock)
    def getSubnetId: ZIO[Any, Nothing, SubnetId] = ZIO.succeed(subnetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest
  ) extends zio.aws.ec2.model.AssociateSubnetCidrBlockRequest.ReadOnly {
    override val ipv6CidrBlock: String = impl.ipv6CidrBlock(): String
    override val subnetId: SubnetId =
      zio.aws.ec2.model.primitives.SubnetId(impl.subnetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateSubnetCidrBlockRequest
  ): zio.aws.ec2.model.AssociateSubnetCidrBlockRequest.ReadOnly = new Wrapper(
    impl
  )
}
