package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TransitGatewayRequestOptions(
    amazonSideAsn: Option[Long] = None,
    autoAcceptSharedAttachments: Option[
      zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue
    ] = None,
    defaultRouteTableAssociation: Option[
      zio.aws.ec2.model.DefaultRouteTableAssociationValue
    ] = None,
    defaultRouteTablePropagation: Option[
      zio.aws.ec2.model.DefaultRouteTablePropagationValue
    ] = None,
    vpnEcmpSupport: Option[zio.aws.ec2.model.VpnEcmpSupportValue] = None,
    dnsSupport: Option[zio.aws.ec2.model.DnsSupportValue] = None,
    multicastSupport: Option[zio.aws.ec2.model.MulticastSupportValue] = None,
    transitGatewayCidrBlocks: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayRequestOptions = {
    import TransitGatewayRequestOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayRequestOptions
      .builder()
      .optionallyWith(amazonSideAsn.map(value => value: java.lang.Long))(
        _.amazonSideAsn
      )
      .optionallyWith(autoAcceptSharedAttachments.map(value => value.unwrap))(
        _.autoAcceptSharedAttachments
      )
      .optionallyWith(defaultRouteTableAssociation.map(value => value.unwrap))(
        _.defaultRouteTableAssociation
      )
      .optionallyWith(defaultRouteTablePropagation.map(value => value.unwrap))(
        _.defaultRouteTablePropagation
      )
      .optionallyWith(vpnEcmpSupport.map(value => value.unwrap))(
        _.vpnEcmpSupport
      )
      .optionallyWith(dnsSupport.map(value => value.unwrap))(_.dnsSupport)
      .optionallyWith(multicastSupport.map(value => value.unwrap))(
        _.multicastSupport
      )
      .optionallyWith(
        transitGatewayCidrBlocks.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.transitGatewayCidrBlocks)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayRequestOptions.ReadOnly =
    zio.aws.ec2.model.TransitGatewayRequestOptions.wrap(buildAwsValue())
}
object TransitGatewayRequestOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayRequestOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayRequestOptions =
      zio.aws.ec2.model.TransitGatewayRequestOptions(
        amazonSideAsn.map(value => value),
        autoAcceptSharedAttachments.map(value => value),
        defaultRouteTableAssociation.map(value => value),
        defaultRouteTablePropagation.map(value => value),
        vpnEcmpSupport.map(value => value),
        dnsSupport.map(value => value),
        multicastSupport.map(value => value),
        transitGatewayCidrBlocks.map(value => value)
      )
    def amazonSideAsn: Option[Long]
    def autoAcceptSharedAttachments
        : Option[zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue]
    def defaultRouteTableAssociation
        : Option[zio.aws.ec2.model.DefaultRouteTableAssociationValue]
    def defaultRouteTablePropagation
        : Option[zio.aws.ec2.model.DefaultRouteTablePropagationValue]
    def vpnEcmpSupport: Option[zio.aws.ec2.model.VpnEcmpSupportValue]
    def dnsSupport: Option[zio.aws.ec2.model.DnsSupportValue]
    def multicastSupport: Option[zio.aws.ec2.model.MulticastSupportValue]
    def transitGatewayCidrBlocks: Option[List[String]]
    def getAmazonSideAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("amazonSideAsn", amazonSideAsn)
    def getAutoAcceptSharedAttachments: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue
    ] = AwsError.unwrapOptionField(
      "autoAcceptSharedAttachments",
      autoAcceptSharedAttachments
    )
    def getDefaultRouteTableAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DefaultRouteTableAssociationValue
    ] = AwsError.unwrapOptionField(
      "defaultRouteTableAssociation",
      defaultRouteTableAssociation
    )
    def getDefaultRouteTablePropagation: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DefaultRouteTablePropagationValue
    ] = AwsError.unwrapOptionField(
      "defaultRouteTablePropagation",
      defaultRouteTablePropagation
    )
    def getVpnEcmpSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnEcmpSupportValue] =
      AwsError.unwrapOptionField("vpnEcmpSupport", vpnEcmpSupport)
    def getDnsSupport: ZIO[Any, AwsError, zio.aws.ec2.model.DnsSupportValue] =
      AwsError.unwrapOptionField("dnsSupport", dnsSupport)
    def getMulticastSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.MulticastSupportValue] =
      AwsError.unwrapOptionField("multicastSupport", multicastSupport)
    def getTransitGatewayCidrBlocks: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("transitGatewayCidrBlocks", transitGatewayCidrBlocks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRequestOptions
  ) extends zio.aws.ec2.model.TransitGatewayRequestOptions.ReadOnly {
    override val amazonSideAsn: Option[Long] =
      scala.Option(impl.amazonSideAsn()).map(value => value: Long)
    override val autoAcceptSharedAttachments
        : Option[zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue] = scala
      .Option(impl.autoAcceptSharedAttachments())
      .map(value =>
        zio.aws.ec2.model.AutoAcceptSharedAttachmentsValue.wrap(value)
      )
    override val defaultRouteTableAssociation
        : Option[zio.aws.ec2.model.DefaultRouteTableAssociationValue] = scala
      .Option(impl.defaultRouteTableAssociation())
      .map(value =>
        zio.aws.ec2.model.DefaultRouteTableAssociationValue.wrap(value)
      )
    override val defaultRouteTablePropagation
        : Option[zio.aws.ec2.model.DefaultRouteTablePropagationValue] = scala
      .Option(impl.defaultRouteTablePropagation())
      .map(value =>
        zio.aws.ec2.model.DefaultRouteTablePropagationValue.wrap(value)
      )
    override val vpnEcmpSupport: Option[zio.aws.ec2.model.VpnEcmpSupportValue] =
      scala
        .Option(impl.vpnEcmpSupport())
        .map(value => zio.aws.ec2.model.VpnEcmpSupportValue.wrap(value))
    override val dnsSupport: Option[zio.aws.ec2.model.DnsSupportValue] = scala
      .Option(impl.dnsSupport())
      .map(value => zio.aws.ec2.model.DnsSupportValue.wrap(value))
    override val multicastSupport
        : Option[zio.aws.ec2.model.MulticastSupportValue] = scala
      .Option(impl.multicastSupport())
      .map(value => zio.aws.ec2.model.MulticastSupportValue.wrap(value))
    override val transitGatewayCidrBlocks: Option[List[String]] = scala
      .Option(impl.transitGatewayCidrBlocks())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRequestOptions
  ): zio.aws.ec2.model.TransitGatewayRequestOptions.ReadOnly = new Wrapper(impl)
}
