package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcEndpointServiceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartVpcEndpointServicePrivateDnsVerificationRequest(
    serviceId: VpcEndpointServiceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest = {
    import StartVpcEndpointServicePrivateDnsVerificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
      .builder()
      .serviceId(VpcEndpointServiceId.unwrap(serviceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest.ReadOnly =
    zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
      .wrap(buildAwsValue())
}
object StartVpcEndpointServicePrivateDnsVerificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest =
      zio.aws.ec2.model
        .StartVpcEndpointServicePrivateDnsVerificationRequest(serviceId)
    def serviceId: VpcEndpointServiceId
    def getServiceId: ZIO[Any, Nothing, VpcEndpointServiceId] =
      ZIO.succeed(serviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
  ) extends zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest.ReadOnly {
    override val serviceId: VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId(impl.serviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
  ): zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest.ReadOnly =
    new Wrapper(impl)
}
