package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SpotMaintenanceStrategies(
    capacityRebalance: Option[zio.aws.ec2.model.SpotCapacityRebalance] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SpotMaintenanceStrategies = {
    import SpotMaintenanceStrategies.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SpotMaintenanceStrategies
      .builder()
      .optionallyWith(capacityRebalance.map(value => value.buildAwsValue()))(
        _.capacityRebalance
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SpotMaintenanceStrategies.ReadOnly =
    zio.aws.ec2.model.SpotMaintenanceStrategies.wrap(buildAwsValue())
}
object SpotMaintenanceStrategies {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SpotMaintenanceStrategies
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SpotMaintenanceStrategies =
      zio.aws.ec2.model.SpotMaintenanceStrategies(
        capacityRebalance.map(value => value.asEditable)
      )
    def capacityRebalance
        : Option[zio.aws.ec2.model.SpotCapacityRebalance.ReadOnly]
    def getCapacityRebalance
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotCapacityRebalance.ReadOnly] =
      AwsError.unwrapOptionField("capacityRebalance", capacityRebalance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SpotMaintenanceStrategies
  ) extends zio.aws.ec2.model.SpotMaintenanceStrategies.ReadOnly {
    override val capacityRebalance
        : Option[zio.aws.ec2.model.SpotCapacityRebalance.ReadOnly] = scala
      .Option(impl.capacityRebalance())
      .map(value => zio.aws.ec2.model.SpotCapacityRebalance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SpotMaintenanceStrategies
  ): zio.aws.ec2.model.SpotMaintenanceStrategies.ReadOnly = new Wrapper(impl)
}
