package zio.aws.ec2.model
import java.lang.Integer
import zio.aws.ec2.model.primitives.{
  TransitGatewayMaxResults,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SearchTransitGatewayRoutesRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    filters: Iterable[zio.aws.ec2.model.Filter],
    maxResults: Option[TransitGatewayMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest = {
    import SearchTransitGatewayRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        maxResults.map(value => TransitGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SearchTransitGatewayRoutesRequest.ReadOnly =
    zio.aws.ec2.model.SearchTransitGatewayRoutesRequest.wrap(buildAwsValue())
}
object SearchTransitGatewayRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SearchTransitGatewayRoutesRequest =
      zio.aws.ec2.model.SearchTransitGatewayRoutesRequest(
        transitGatewayRouteTableId,
        filters.map { item =>
          item.asEditable
        },
        maxResults.map(value => value)
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def filters: List[zio.aws.ec2.model.Filter.ReadOnly]
    def maxResults: Option[TransitGatewayMaxResults]
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getFilters: ZIO[Any, Nothing, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      ZIO.succeed(filters)
    def getMaxResults: ZIO[Any, AwsError, TransitGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest
  ) extends zio.aws.ec2.model.SearchTransitGatewayRoutesRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val filters: List[zio.aws.ec2.model.Filter.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.ec2.model.Filter.wrap(item)
      }
      .toList
    override val maxResults: Option[TransitGatewayMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayMaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest
  ): zio.aws.ec2.model.SearchTransitGatewayRoutesRequest.ReadOnly = new Wrapper(
    impl
  )
}
