package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyVpnConnectionOptionsResponse(
    vpnConnection: Option[zio.aws.ec2.model.VpnConnection] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse = {
    import ModifyVpnConnectionOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse
      .builder()
      .optionallyWith(vpnConnection.map(value => value.buildAwsValue()))(
        _.vpnConnection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.wrap(buildAwsValue())
}
object ModifyVpnConnectionOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse =
      zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse(
        vpnConnection.map(value => value.asEditable)
      )
    def vpnConnection: Option[zio.aws.ec2.model.VpnConnection.ReadOnly]
    def getVpnConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnConnection.ReadOnly] =
      AwsError.unwrapOptionField("vpnConnection", vpnConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse
  ) extends zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.ReadOnly {
    override val vpnConnection
        : Option[zio.aws.ec2.model.VpnConnection.ReadOnly] = scala
      .Option(impl.vpnConnection())
      .map(value => zio.aws.ec2.model.VpnConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionOptionsResponse
  ): zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
