package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  PrefixListResourceId,
  TransitGatewayRouteTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyTransitGatewayPrefixListReferenceRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    prefixListId: PrefixListResourceId,
    transitGatewayAttachmentId: Option[TransitGatewayAttachmentId] = None,
    blackhole: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest = {
    import ModifyTransitGatewayPrefixListReferenceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .optionallyWith(
        transitGatewayAttachmentId.map(value =>
          TransitGatewayAttachmentId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentId)
      .optionallyWith(blackhole.map(value => value: java.lang.Boolean))(
        _.blackhole
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest.ReadOnly =
    zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest
      .wrap(buildAwsValue())
}
object ModifyTransitGatewayPrefixListReferenceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest =
      zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest(
        transitGatewayRouteTableId,
        prefixListId,
        transitGatewayAttachmentId.map(value => value),
        blackhole.map(value => value)
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def prefixListId: PrefixListResourceId
    def transitGatewayAttachmentId: Option[TransitGatewayAttachmentId]
    def blackhole: Option[Boolean]
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, AwsError, TransitGatewayAttachmentId] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getBlackhole: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("blackhole", blackhole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest
  ) extends zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
    override val transitGatewayAttachmentId
        : Option[TransitGatewayAttachmentId] = scala
      .Option(impl.transitGatewayAttachmentId())
      .map(value =>
        zio.aws.ec2.model.primitives.TransitGatewayAttachmentId(value)
      )
    override val blackhole: Option[Boolean] =
      scala.Option(impl.blackhole()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest
  ): zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest.ReadOnly =
    new Wrapper(impl)
}
