package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{LaunchTemplateName, LaunchTemplateId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyLaunchTemplateRequest(
    clientToken: Option[String] = None,
    launchTemplateId: Option[LaunchTemplateId] = None,
    launchTemplateName: Option[LaunchTemplateName] = None,
    defaultVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest = {
    import ModifyLaunchTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(defaultVersion.map(value => value: java.lang.String))(
        _.defaultVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyLaunchTemplateRequest.ReadOnly =
    zio.aws.ec2.model.ModifyLaunchTemplateRequest.wrap(buildAwsValue())
}
object ModifyLaunchTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyLaunchTemplateRequest =
      zio.aws.ec2.model.ModifyLaunchTemplateRequest(
        clientToken.map(value => value),
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        defaultVersion.map(value => value)
      )
    def clientToken: Option[String]
    def launchTemplateId: Option[LaunchTemplateId]
    def launchTemplateName: Option[LaunchTemplateName]
    def defaultVersion: Option[String]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getDefaultVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultVersion", defaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest
  ) extends zio.aws.ec2.model.ModifyLaunchTemplateRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val launchTemplateId: Option[LaunchTemplateId] = scala
      .Option(impl.launchTemplateId())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Option[LaunchTemplateName] = scala
      .Option(impl.launchTemplateName())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val defaultVersion: Option[String] =
      scala.Option(impl.defaultVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyLaunchTemplateRequest
  ): zio.aws.ec2.model.ModifyLaunchTemplateRequest.ReadOnly = new Wrapper(impl)
}
