package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait LocalStorageType {
  def unwrap: software.amazon.awssdk.services.ec2.model.LocalStorageType
}
object LocalStorageType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.LocalStorageType
  ): zio.aws.ec2.model.LocalStorageType = value match {
    case software.amazon.awssdk.services.ec2.model.LocalStorageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.LocalStorageType.HDD =>
      val r = hdd
      r
    case software.amazon.awssdk.services.ec2.model.LocalStorageType.SSD =>
      val r = ssd
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.LocalStorageType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalStorageType =
      software.amazon.awssdk.services.ec2.model.LocalStorageType.UNKNOWN_TO_SDK_VERSION
  }
  case object hdd extends zio.aws.ec2.model.LocalStorageType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalStorageType =
      software.amazon.awssdk.services.ec2.model.LocalStorageType.HDD
  }
  case object ssd extends zio.aws.ec2.model.LocalStorageType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.LocalStorageType =
      software.amazon.awssdk.services.ec2.model.LocalStorageType.SSD
  }
}
