package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Ipv4PrefixSpecificationRequest(
    ipv4Prefix: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest = {
    import Ipv4PrefixSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest
      .builder()
      .optionallyWith(ipv4Prefix.map(value => value: java.lang.String))(
        _.ipv4Prefix
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.wrap(buildAwsValue())
}
object Ipv4PrefixSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.Ipv4PrefixSpecificationRequest =
      zio.aws.ec2.model
        .Ipv4PrefixSpecificationRequest(ipv4Prefix.map(value => value))
    def ipv4Prefix: Option[String]
    def getIpv4Prefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv4Prefix", ipv4Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest
  ) extends zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly {
    override val ipv4Prefix: Option[String] =
      scala.Option(impl.ipv4Prefix()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.Ipv4PrefixSpecificationRequest
  ): zio.aws.ec2.model.Ipv4PrefixSpecificationRequest.ReadOnly = new Wrapper(
    impl
  )
}
